/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.source;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.source.AbstractJarSourceMojo;
import org.codehaus.plexus.archiver.ArchiverException;

public class JarDefaultSourceMojo
extends AbstractJarSourceMojo {
    public void execute() throws MojoExecutionException {
        if ("pom".equals(this.packaging)) {
            this.getLog().info((CharSequence)("NOT adding sources to attached artifacts for packaging: '" + this.packaging + "'."));
        } else if (this.getProject().getArtifact().getClassifier() != null) {
            this.getLog().warn((CharSequence)("NOT adding sources to artifacts with classifier as Maven only supports one classifier per artifact. Current artifact [" + this.getProject().getArtifact().getId() + "] has a [" + this.getProject().getArtifact().getClassifier() + "] classifier."));
        } else {
            File outputFile = new File(this.outputDirectory, this.finalName + "-sources.jar");
            File[] sourceDirectories = this.getDefaultSources();
            try {
                this.createJar(outputFile, sourceDirectories, this.createArchiver());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), (Exception)e);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), (Exception)((Object)e));
            }
            this.attachArtifact(outputFile, "sources");
        }
    }
}

