/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene54.Lucene54DocValuesFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.rangetree.RangeTreeDocValuesConsumer;
import org.apache.lucene.rangetree.RangeTreeDocValuesProducer;
import org.apache.lucene.rangetree.RangeTreeWriter;

public class RangeTreeDocValuesFormat
extends DocValuesFormat {
    static final String DATA_CODEC_NAME = "RangeTreeData";
    static final int DATA_VERSION_START = 0;
    static final int DATA_VERSION_CURRENT = 0;
    static final String DATA_EXTENSION = "ndd";
    static final String META_CODEC_NAME = "RangeTreeMeta";
    static final int META_VERSION_START = 0;
    static final int META_VERSION_CURRENT = 0;
    static final String META_EXTENSION = "ndm";
    private final int maxPointsInLeafNode;
    private final int maxPointsSortInHeap;
    private final DocValuesFormat delegate = new Lucene54DocValuesFormat();

    public RangeTreeDocValuesFormat() {
        this(1024, 131072);
    }

    public RangeTreeDocValuesFormat(int maxPointsInLeafNode, int maxPointsSortInHeap) {
        super("RangeTree");
        RangeTreeWriter.verifyParams(maxPointsInLeafNode, maxPointsSortInHeap);
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new RangeTreeDocValuesConsumer(this.delegate.fieldsConsumer(state), state, this.maxPointsInLeafNode, this.maxPointsSortInHeap);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new RangeTreeDocValuesProducer(this.delegate.fieldsProducer(state), state);
    }
}

