/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kylin.jdbc.IRemoteClient;
import org.apache.kylin.jdbc.KylinJdbcFactory;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.UnregisteredDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConnection
extends AvaticaConnection {
    private static final Logger logger = LoggerFactory.getLogger(KylinConnection.class);
    private final String baseUrl;
    private final String project;
    private final IRemoteClient remoteClient;

    protected KylinConnection(UnregisteredDriver driver, KylinJdbcFactory factory, String url, Properties info) throws SQLException {
        super(driver, factory, url, info);
        String odbcUrl = url;
        odbcUrl = odbcUrl.replace("jdbc:kylin://", "");
        String[] temps = odbcUrl.split("/");
        assert (temps.length == 2);
        this.baseUrl = temps[0];
        this.project = temps[1];
        logger.debug("Kylin base url " + this.baseUrl + ", project name " + this.project);
        this.remoteClient = factory.newRemoteClient(this);
        try {
            this.remoteClient.connect();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    String getProject() {
        return this.project;
    }

    Properties getConnectionProperties() {
        return this.info;
    }

    @Override
    public AvaticaStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl()).isAutoCommit() == null) {
            this.setAutoCommit(true);
        }
        return super.getAutoCommit();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl()).isReadOnly() == null) {
            this.setReadOnly(true);
        }
        return super.isReadOnly();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Meta.Signature sig = this.mockPreparedSignature(sql);
        return this.factory().newPreparedStatement(this, null, sig, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    Meta.Signature mockPreparedSignature(String sql) {
        ArrayList<AvaticaParameter> params = new ArrayList<AvaticaParameter>();
        int startIndex = 0;
        while (sql.indexOf("?", startIndex) >= 0) {
            AvaticaParameter param = new AvaticaParameter(false, 0, 0, 0, null, null, null);
            params.add(param);
            startIndex = sql.indexOf("?", startIndex) + 1;
        }
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        Map<String, Object> internalParams = Collections.emptyMap();
        return new Meta.Signature(columns, sql, params, internalParams, Meta.CursorFactory.ARRAY, Meta.StatementType.SELECT);
    }

    private KylinJdbcFactory factory() {
        return (KylinJdbcFactory)this.factory;
    }

    public IRemoteClient getRemoteClient() {
        return this.remoteClient;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        try {
            this.remoteClient.close();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }
}

