/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.SnapshottableHashTable;
import org.apache.kafka.timeline.TimelineHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class SnapshottableHashTableTest {
    private static final TestElement E_1A = new TestElement(1, 'A');
    private static final TestElement E_1B = new TestElement(1, 'B');
    private static final TestElement E_2A = new TestElement(2, 'A');
    private static final TestElement E_3A = new TestElement(3, 'A');
    private static final TestElement E_3B = new TestElement(3, 'B');

    @Test
    public void testEmptyTable() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        SnapshottableHashTable table = new SnapshottableHashTable(registry, 1);
        Assertions.assertEquals((int)0, (int)table.snapshottableSize(Long.MAX_VALUE));
    }

    @Test
    public void testDeleteOnEmptyDeltaTable() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashSet set = new TimelineHashSet(registry, 5);
        registry.getOrCreateSnapshot(100L);
        set.add((Object)"bar");
        registry.getOrCreateSnapshot(200L);
        set.add((Object)"baz");
        registry.revertToSnapshot(100L);
        Assertions.assertTrue((boolean)set.isEmpty());
        set.add((Object)"foo");
        registry.getOrCreateSnapshot(300L);
        set.remove((Object)"bar");
        registry.revertToSnapshot(100L);
        Assertions.assertTrue((boolean)set.isEmpty());
        set.add((Object)"qux");
        registry.getOrCreateSnapshot(400L);
        Assertions.assertEquals((int)1, (int)set.size());
        set.add((Object)"fred");
        set.add((Object)"thud");
        registry.getOrCreateSnapshot(500L);
        Assertions.assertEquals((int)3, (int)set.size());
        set.remove((Object)"qux");
        Assertions.assertEquals((int)2, (int)set.size());
        registry.revertToSnapshot(400L);
        Assertions.assertEquals((int)1, (int)set.size());
        registry.revertToSnapshot(100L);
        Assertions.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testAddAndRemove() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        SnapshottableHashTable table = new SnapshottableHashTable(registry, 1);
        Assertions.assertTrue((null == table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_1B) ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)table.snapshottableSize(Long.MAX_VALUE));
        registry.getOrCreateSnapshot(0L);
        Assertions.assertTrue((E_1B == table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_1A) ? 1 : 0) != 0);
        Assertions.assertTrue((E_1B == table.snapshottableGet((Object)E_1A, 0L) ? 1 : 0) != 0);
        Assertions.assertTrue((E_1A == table.snapshottableGet((Object)E_1A, Long.MAX_VALUE) ? 1 : 0) != 0);
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_2A));
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_3A));
        Assertions.assertEquals((int)3, (int)table.snapshottableSize(Long.MAX_VALUE));
        Assertions.assertEquals((int)1, (int)table.snapshottableSize(0L));
        registry.getOrCreateSnapshot(1L);
        Assertions.assertEquals((Object)E_1A, (Object)table.snapshottableRemove((Object)E_1B));
        Assertions.assertEquals((Object)E_2A, (Object)table.snapshottableRemove((Object)E_2A));
        Assertions.assertEquals((Object)E_3A, (Object)table.snapshottableRemove((Object)E_3A));
        Assertions.assertEquals((int)0, (int)table.snapshottableSize(Long.MAX_VALUE));
        Assertions.assertEquals((int)1, (int)table.snapshottableSize(0L));
        Assertions.assertEquals((int)3, (int)table.snapshottableSize(1L));
        registry.deleteSnapshot(0L);
        Assertions.assertEquals((Object)"No in-memory snapshot for epoch 0. Snapshot epochs are: 1", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> table.snapshottableSize(0L))).getMessage());
        registry.deleteSnapshot(1L);
        Assertions.assertEquals((int)0, (int)table.snapshottableSize(Long.MAX_VALUE));
    }

    @Test
    public void testIterateOverSnapshot() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        SnapshottableHashTable table = new SnapshottableHashTable(registry, 1);
        Assertions.assertTrue((boolean)table.snapshottableAddUnlessPresent((SnapshottableHashTable.ElementWithStartEpoch)E_1B));
        Assertions.assertFalse((boolean)table.snapshottableAddUnlessPresent((SnapshottableHashTable.ElementWithStartEpoch)E_1A));
        Assertions.assertTrue((boolean)table.snapshottableAddUnlessPresent((SnapshottableHashTable.ElementWithStartEpoch)E_2A));
        Assertions.assertTrue((boolean)table.snapshottableAddUnlessPresent((SnapshottableHashTable.ElementWithStartEpoch)E_3A));
        registry.getOrCreateSnapshot(0L);
        SnapshottableHashTableTest.assertIteratorYields(table.snapshottableIterator(0L), E_1B, E_2A, E_3A);
        Assertions.assertEquals((Object)E_1B, (Object)table.snapshottableRemove((Object)E_1B));
        SnapshottableHashTableTest.assertIteratorYields(table.snapshottableIterator(0L), E_1B, E_2A, E_3A);
        Assertions.assertEquals(null, (Object)table.snapshottableRemove((Object)E_1A));
        SnapshottableHashTableTest.assertIteratorYields(table.snapshottableIterator(Long.MAX_VALUE), E_2A, E_3A);
        Assertions.assertEquals((Object)E_2A, (Object)table.snapshottableRemove((Object)E_2A));
        Assertions.assertEquals((Object)E_3A, (Object)table.snapshottableRemove((Object)E_3A));
        SnapshottableHashTableTest.assertIteratorYields(table.snapshottableIterator(0L), E_1B, E_2A, E_3A);
    }

    @Test
    public void testIterateOverSnapshotWhileExpandingTable() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        SnapshottableHashTable table = new SnapshottableHashTable(registry, 1);
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_1A));
        registry.getOrCreateSnapshot(0L);
        Iterator iter = table.snapshottableIterator(0L);
        Assertions.assertTrue((boolean)table.snapshottableAddUnlessPresent((SnapshottableHashTable.ElementWithStartEpoch)E_2A));
        Assertions.assertTrue((boolean)table.snapshottableAddUnlessPresent((SnapshottableHashTable.ElementWithStartEpoch)E_3A));
        SnapshottableHashTableTest.assertIteratorYields(iter, E_1A);
    }

    @Test
    public void testIterateOverSnapshotWhileDeletingAndReplacing() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        SnapshottableHashTable table = new SnapshottableHashTable(registry, 1);
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_1A));
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_2A));
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_3A));
        Assertions.assertEquals((Object)E_1A, (Object)table.snapshottableRemove((Object)E_1A));
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_1B));
        registry.getOrCreateSnapshot(0L);
        Iterator iter = table.snapshottableIterator(0L);
        ArrayList iterElements = new ArrayList();
        iterElements.add(iter.next());
        Assertions.assertEquals((Object)E_2A, (Object)table.snapshottableRemove((Object)E_2A));
        Assertions.assertEquals((Object)E_3A, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_3B));
        iterElements.add(iter.next());
        Assertions.assertEquals((Object)E_1B, (Object)table.snapshottableRemove((Object)E_1B));
        iterElements.add(iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        SnapshottableHashTableTest.assertIteratorYields(iterElements.iterator(), E_1B, E_2A, E_3A);
    }

    @Test
    public void testRevert() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        SnapshottableHashTable table = new SnapshottableHashTable(registry, 1);
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_1A));
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_2A));
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_3A));
        registry.getOrCreateSnapshot(0L);
        Assertions.assertEquals((Object)E_1A, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_1B));
        Assertions.assertEquals((Object)E_3A, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_3B));
        registry.getOrCreateSnapshot(1L);
        Assertions.assertEquals((int)3, (int)table.snapshottableSize(Long.MAX_VALUE));
        SnapshottableHashTableTest.assertIteratorYields(table.snapshottableIterator(Long.MAX_VALUE), E_1B, E_2A, E_3B);
        table.snapshottableRemove((Object)E_1B);
        table.snapshottableRemove((Object)E_2A);
        table.snapshottableRemove((Object)E_3B);
        Assertions.assertEquals((int)0, (int)table.snapshottableSize(Long.MAX_VALUE));
        Assertions.assertEquals((int)3, (int)table.snapshottableSize(0L));
        Assertions.assertEquals((int)3, (int)table.snapshottableSize(1L));
        registry.revertToSnapshot(0L);
        SnapshottableHashTableTest.assertIteratorYields(table.snapshottableIterator(Long.MAX_VALUE), E_1A, E_2A, E_3A);
    }

    @Test
    public void testReset() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        SnapshottableHashTable table = new SnapshottableHashTable(registry, 1);
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_1A));
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_2A));
        Assertions.assertEquals(null, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_3A));
        registry.getOrCreateSnapshot(0L);
        Assertions.assertEquals((Object)E_1A, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_1B));
        Assertions.assertEquals((Object)E_3A, (Object)table.snapshottableAddOrReplace((SnapshottableHashTable.ElementWithStartEpoch)E_3B));
        registry.getOrCreateSnapshot(1L);
        registry.reset();
        Assertions.assertEquals(Collections.emptyList(), (Object)registry.epochsList());
        SnapshottableHashTableTest.assertIteratorYields(table.snapshottableIterator(Long.MAX_VALUE), new Object[0]);
    }

    private static void assertIteratorYields(Iterator<? extends Object> iter, Object ... expected) {
        IdentityHashMap<Object, Boolean> remaining = new IdentityHashMap<Object, Boolean>();
        for (Object object : expected) {
            remaining.put(object, true);
        }
        ArrayList<Object> extraObjects = new ArrayList<Object>();
        boolean i = false;
        while (iter.hasNext()) {
            Object object = iter.next();
            Assertions.assertNotNull((Object)object);
            if (remaining.remove(object) != null) continue;
            extraObjects.add(object);
        }
        if (!extraObjects.isEmpty() || !remaining.isEmpty()) {
            throw new RuntimeException("Found extra object(s): [" + String.join((CharSequence)", ", extraObjects.stream().map(e -> e.toString()).collect(Collectors.toList())) + "] and didn't find object(s): [" + String.join((CharSequence)", ", remaining.keySet().stream().map(e -> e.toString()).collect(Collectors.toList())) + "]");
        }
    }

    static class TestElement
    implements SnapshottableHashTable.ElementWithStartEpoch {
        private final int i;
        private final char j;
        private long startEpoch = Long.MAX_VALUE;

        TestElement(int i, char j) {
            this.i = i;
            this.j = j;
        }

        public void setStartEpoch(long startEpoch) {
            this.startEpoch = startEpoch;
        }

        public long startEpoch() {
            return this.startEpoch;
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TestElement)) {
                return false;
            }
            TestElement other = (TestElement)o;
            return other.i == this.i;
        }

        public String toString() {
            return String.format("E_%d%c(%s)", this.i, Character.valueOf(this.j), System.identityHashCode(this));
        }
    }
}

