/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class MunkresAssignment {
    private static final byte NONE = 0;
    private static final byte STAR = 1;
    private static final byte PRIME = 2;
    private final boolean transposed;
    private final int rows;
    private final int cols;
    private float[][] cost;
    private byte[][] mask;
    private boolean[] rowsCovered;
    private boolean[] colsCovered;
    private Deque<Pair<Integer, Integer>> path;
    private int[] assignments;
    private float[] leastInRow;
    private int[] leastInRowIndex;
    private float[] rowAdjust;
    private float[] colAdjust;

    public MunkresAssignment(float[][] costMatrix) {
        int c;
        int r;
        boolean bl = this.transposed = costMatrix.length > costMatrix[0].length;
        if (this.transposed) {
            this.rows = costMatrix[0].length;
            this.cols = costMatrix.length;
        } else {
            this.rows = costMatrix.length;
            this.cols = costMatrix[0].length;
        }
        this.cost = new float[this.rows][this.cols];
        this.mask = new byte[this.rows][this.cols];
        this.rowsCovered = new boolean[this.rows];
        this.colsCovered = new boolean[this.cols];
        this.path = new LinkedList<Pair<Integer, Integer>>();
        this.leastInRow = new float[this.rows];
        this.leastInRowIndex = new int[this.rows];
        this.rowAdjust = new float[this.rows];
        this.colAdjust = new float[this.cols];
        this.assignments = null;
        if (this.transposed) {
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.cols; ++c) {
                    this.cost[r][c] = costMatrix[c][r];
                }
            }
        } else {
            for (r = 0; r < this.rows; ++r) {
                System.arraycopy(costMatrix[r], 0, this.cost[r], 0, this.cols);
            }
        }
        for (r = 0; r < this.rows; ++r) {
            for (c = 0; c < this.cols; ++c) {
                if (this.cost[r][c] != Float.POSITIVE_INFINITY) continue;
                this.cost[r][c] = Float.MAX_VALUE;
            }
        }
    }

    public int[] solve() {
        if (this.assignments != null) {
            return this.assignments;
        }
        this.preliminaries();
        while (!this.testIsDone()) {
            while (!this.stepOne()) {
                this.stepThree();
            }
            this.stepTwo();
        }
        if (this.transposed) {
            this.assignments = new int[this.cols];
            block2: for (int c = 0; c < this.cols; ++c) {
                for (int r = 0; r < this.rows; ++r) {
                    if (this.mask[r][c] != 1) continue;
                    this.assignments[c] = r;
                    continue block2;
                }
                this.assignments[c] = -1;
            }
        } else {
            this.assignments = new int[this.rows];
            block4: for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.cols; ++c) {
                    if (this.mask[r][c] != 1) continue;
                    this.assignments[r] = c;
                    continue block4;
                }
            }
        }
        this.cost = null;
        this.mask = null;
        this.rowsCovered = null;
        this.colsCovered = null;
        this.path = null;
        this.leastInRow = null;
        this.leastInRowIndex = null;
        this.rowAdjust = null;
        this.colAdjust = null;
        return this.assignments;
    }

    private void preliminaries() {
        for (int r = 0; r < this.rows; ++r) {
            int c;
            float min = Float.POSITIVE_INFINITY;
            for (c = 0; c < this.cols; ++c) {
                min = Math.min(min, this.cost[r][c]);
            }
            for (c = 0; c < this.cols; ++c) {
                float[] fArray = this.cost[r];
                int n = c;
                fArray[n] = fArray[n] - min;
                if (this.cost[r][c] != 0.0f || this.rowsCovered[r] || this.colsCovered[c]) continue;
                this.mask[r][c] = 1;
                this.rowsCovered[r] = true;
                this.colsCovered[c] = true;
            }
        }
        Arrays.fill(this.rowsCovered, false);
        Arrays.fill(this.colsCovered, false);
    }

    private boolean testIsDone() {
        int c;
        int r;
        int c2;
        for (int r2 = 0; r2 < this.rows; ++r2) {
            for (c2 = 0; c2 < this.cols; ++c2) {
                if (this.mask[r2][c2] != 1) continue;
                this.colsCovered[c2] = true;
            }
        }
        int coveredCols = 0;
        for (c2 = 0; c2 < this.cols; ++c2) {
            coveredCols += this.colsCovered[c2] ? 1 : 0;
        }
        for (r = 0; r < this.rows; ++r) {
            for (c = 0; c < this.cols; ++c) {
                float[] fArray = this.cost[r];
                int n = c;
                fArray[n] = fArray[n] + this.rowAdjust[r];
                float[] fArray2 = this.cost[r];
                int n2 = c;
                fArray2[n2] = fArray2[n2] + this.colAdjust[c];
            }
        }
        Arrays.fill(this.rowAdjust, 0.0f);
        Arrays.fill(this.colAdjust, 0.0f);
        for (r = 0; r < this.rows; ++r) {
            this.leastInRow[r] = Float.POSITIVE_INFINITY;
            for (c = 0; c < this.cols; ++c) {
                if (this.rowsCovered[r] || this.colsCovered[c] || !(this.cost[r][c] < this.leastInRow[r])) continue;
                this.leastInRow[r] = this.cost[r][c];
                this.leastInRowIndex[r] = c;
            }
        }
        return coveredCols == this.cols || coveredCols >= this.rows;
    }

    private boolean stepOne() {
        Pair<Integer, Integer> zero;
        while (true) {
            if ((zero = this.findUncoveredZero()) == null) {
                return false;
            }
            this.mask[zero.getFirst().intValue()][zero.getSecond().intValue()] = 2;
            Pair<Integer, Integer> star = this.starInRow(zero.getFirst());
            if (star == null) break;
            this.rowsCovered[star.getFirst().intValue()] = true;
            this.colsCovered[star.getSecond().intValue()] = false;
            this.updateMin(star.getFirst(), star.getSecond());
        }
        this.path.clear();
        this.path.offerLast(new Pair<Integer, Integer>(zero.getFirst(), zero.getSecond()));
        return true;
    }

    private void stepTwo() {
        Pair<Integer, Integer> star;
        while ((star = this.starInCol(this.path.getLast().getSecond())) != null) {
            this.path.offerLast(star);
            Pair<Integer, Integer> prime = this.primeInRow(this.path.getLast().getFirst());
            this.path.offerLast(prime);
        }
        for (Pair<Integer, Integer> p : this.path) {
            if (this.mask[p.getFirst()][p.getSecond()] == 1) {
                this.mask[p.getFirst().intValue()][p.getSecond().intValue()] = 0;
                continue;
            }
            this.mask[p.getFirst().intValue()][p.getSecond().intValue()] = 1;
        }
        Arrays.fill(this.rowsCovered, false);
        Arrays.fill(this.colsCovered, false);
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.mask[r][c] != 2) continue;
                this.mask[r][c] = 0;
            }
        }
    }

    private void stepThree() {
        int r;
        float min = this.leastInRow[0];
        for (r = 1; r < this.rows; ++r) {
            if (!(this.leastInRow[r] < min)) continue;
            min = this.leastInRow[r];
        }
        for (r = 0; r < this.rows; ++r) {
            if (!this.rowsCovered[r]) continue;
            int n = r;
            this.rowAdjust[n] = this.rowAdjust[n] + min;
        }
        for (int c = 0; c < this.cols; ++c) {
            if (this.colsCovered[c]) continue;
            int n = c;
            this.colAdjust[n] = this.colAdjust[n] - min;
        }
        for (r = 0; r < this.rows; ++r) {
            if (!this.colsCovered[this.leastInRowIndex[r]]) {
                int n = r;
                this.leastInRow[n] = this.leastInRow[n] - min;
                continue;
            }
            for (int c = 0; c < this.cols; ++c) {
                if (!(this.cost[r][c] + this.colAdjust[c] + this.rowAdjust[r] < this.leastInRow[r])) continue;
                this.leastInRow[r] = this.cost[r][c] + this.colAdjust[c] + this.rowAdjust[r];
                this.leastInRowIndex[r] = c;
            }
        }
    }

    private Pair<Integer, Integer> findUncoveredZero() {
        for (int r = 0; r < this.rows; ++r) {
            if (this.leastInRow[r] != 0.0f) continue;
            return new Pair<Integer, Integer>(r, this.leastInRowIndex[r]);
        }
        return null;
    }

    private void updateMin(int row, int col) {
        this.leastInRow[row] = Float.POSITIVE_INFINITY;
        for (int r = 0; r < this.rows; ++r) {
            if (this.rowsCovered[r] || !(this.cost[r][col] < this.leastInRow[r])) continue;
            this.leastInRow[r] = this.cost[r][col];
            this.leastInRowIndex[r] = col;
        }
    }

    private Pair<Integer, Integer> starInRow(int r) {
        for (int c = 0; c < this.cols; ++c) {
            if (this.mask[r][c] != 1) continue;
            return new Pair<Integer, Integer>(r, c);
        }
        return null;
    }

    private Pair<Integer, Integer> starInCol(int c) {
        for (int r = 0; r < this.rows; ++r) {
            if (this.mask[r][c] != 1) continue;
            return new Pair<Integer, Integer>(r, c);
        }
        return null;
    }

    private Pair<Integer, Integer> primeInRow(int r) {
        for (int c = 0; c < this.cols; ++c) {
            if (this.mask[r][c] != 2) continue;
            return new Pair<Integer, Integer>(r, c);
        }
        return null;
    }
}

