/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.token.Token;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.security.UserProvider;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FsDelegationToken {
    private static final Log LOG = LogFactory.getLog(FsDelegationToken.class);
    private final UserProvider userProvider;
    private final String renewer;
    private boolean hasForwardedToken = false;
    private Token<?> userToken = null;
    private FileSystem fs = null;

    public FsDelegationToken(UserProvider userProvider, String renewer) {
        this.userProvider = userProvider;
        this.renewer = renewer;
    }

    public void acquireDelegationToken(FileSystem fs) throws IOException {
        if (this.userProvider.isHadoopSecurityEnabled()) {
            this.fs = fs;
            this.userToken = this.userProvider.getCurrent().getToken("HDFS_DELEGATION_TOKEN", fs.getCanonicalServiceName());
            if (this.userToken == null) {
                this.hasForwardedToken = false;
                try {
                    this.userToken = fs.getDelegationToken(this.renewer);
                }
                catch (NullPointerException npe) {
                    LOG.error((Object)("Failed to get token for " + this.renewer));
                }
            } else {
                this.hasForwardedToken = true;
                LOG.info((Object)("Use the existing token: " + this.userToken));
            }
        }
    }

    public void releaseDelegationToken() {
        if (this.userProvider.isHadoopSecurityEnabled()) {
            if (this.userToken != null && !this.hasForwardedToken) {
                try {
                    this.userToken.cancel(this.fs.getConf());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to cancel HDFS delegation token: " + this.userToken), (Throwable)e);
                }
            }
            this.userToken = null;
            this.fs = null;
        }
    }

    public UserProvider getUserProvider() {
        return this.userProvider;
    }

    public String getRenewer() {
        return this.renewer;
    }

    public Token<?> getUserToken() {
        return this.userToken;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }
}

