/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public abstract class Compactor {
    private static final Log LOG = LogFactory.getLog(Compactor.class);
    protected CompactionProgress progress;
    protected Configuration conf;
    protected Store store;
    private int compactionKVMax;
    protected Compression.Algorithm compactionCompression;
    protected int keepSeqIdPeriod;
    private static final AtomicInteger NAME_COUNTER = new AtomicInteger(0);

    Compactor(Configuration conf, Store store) {
        this.conf = conf;
        this.store = store;
        this.compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        this.compactionCompression = this.store.getFamily() == null ? Compression.Algorithm.NONE : this.store.getFamily().getCompactionCompression();
        this.keepSeqIdPeriod = Math.max(this.conf.getInt("hbase.hstore.compaction.keep.seqId.period", 5), 5);
    }

    public CompactionProgress getProgress() {
        return this.progress;
    }

    protected FileDetails getFileDetails(Collection<StoreFile> filesToCompact, boolean allFiles) throws IOException {
        FileDetails fd = new FileDetails();
        long oldestHFileTimeStampToKeepMVCC = System.currentTimeMillis() - 86400000L * (long)this.keepSeqIdPeriod;
        for (StoreFile file : filesToCompact) {
            if (allFiles && file.getModificationTimeStamp() < oldestHFileTimeStampToKeepMVCC && fd.minSeqIdToKeep < file.getMaxMemstoreTS()) {
                fd.minSeqIdToKeep = file.getMaxMemstoreTS();
            }
            long seqNum = file.getMaxSequenceId();
            fd.maxSeqId = Math.max(fd.maxSeqId, seqNum);
            StoreFile.Reader r = file.getReader();
            if (r == null) {
                LOG.warn((Object)("Null reader for " + file.getPath()));
                continue;
            }
            long keyCount = r.getEntries();
            fd.maxKeyCount += keyCount;
            Map<byte[], byte[]> fileInfo = r.loadFileInfo();
            byte[] tmp = null;
            if (r.isBulkLoaded()) {
                fd.maxMVCCReadpoint = Math.max(fd.maxMVCCReadpoint, r.getSequenceID());
            } else {
                tmp = fileInfo.get(HFileWriterV2.MAX_MEMSTORE_TS_KEY);
                if (tmp != null) {
                    fd.maxMVCCReadpoint = Math.max(fd.maxMVCCReadpoint, Bytes.toLong(tmp));
                }
            }
            tmp = fileInfo.get(HFile.FileInfo.MAX_TAGS_LEN);
            if (tmp != null) {
                fd.maxTagsLength = Math.max(fd.maxTagsLength, Bytes.toInt(tmp));
            }
            long earliestPutTs = 0L;
            if (allFiles) {
                tmp = fileInfo.get(StoreFile.EARLIEST_PUT_TS);
                if (tmp == null) {
                    earliestPutTs = Long.MIN_VALUE;
                    fd.earliestPutTs = Long.MIN_VALUE;
                } else {
                    earliestPutTs = Bytes.toLong(tmp);
                    fd.earliestPutTs = Math.min(fd.earliestPutTs, earliestPutTs);
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Compacting " + file + ", keycount=" + keyCount + ", bloomtype=" + r.getBloomFilterType().toString() + ", size=" + StringUtils.TraditionalBinaryPrefix.long2String((long)r.length(), (String)"", (int)1) + ", encoding=" + (Object)((Object)r.getHFileReader().getDataBlockEncoding()) + ", seqNum=" + seqNum + (allFiles ? ", earliestPutTs=" + earliestPutTs : "")));
        }
        return fd;
    }

    protected List<StoreFileScanner> createFileScanners(Collection<StoreFile> filesToCompact, long smallestReadPoint, boolean useDropBehind) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(filesToCompact, false, false, true, useDropBehind, smallestReadPoint);
    }

    protected long getSmallestReadPoint() {
        return this.store.getSmallestReadPoint();
    }

    protected InternalScanner preCreateCoprocScanner(CompactionRequest request, ScanType scanType, long earliestPutTs, List<StoreFileScanner> scanners) throws IOException {
        return this.preCreateCoprocScanner(request, scanType, earliestPutTs, scanners, null);
    }

    protected InternalScanner preCreateCoprocScanner(final CompactionRequest request, final ScanType scanType, final long earliestPutTs, final List<StoreFileScanner> scanners, User user) throws IOException {
        if (this.store.getCoprocessorHost() == null) {
            return null;
        }
        if (user == null) {
            return this.store.getCoprocessorHost().preCompactScannerOpen(this.store, scanners, scanType, earliestPutTs, request);
        }
        try {
            return (InternalScanner)user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<InternalScanner>(){

                @Override
                public InternalScanner run() throws Exception {
                    return Compactor.this.store.getCoprocessorHost().preCompactScannerOpen(Compactor.this.store, scanners, scanType, earliestPutTs, request);
                }
            });
        }
        catch (InterruptedException ie) {
            InterruptedIOException iioe = new InterruptedIOException();
            iioe.initCause(ie);
            throw iioe;
        }
    }

    protected InternalScanner postCreateCoprocScanner(final CompactionRequest request, final ScanType scanType, final InternalScanner scanner, User user) throws IOException {
        if (this.store.getCoprocessorHost() == null) {
            return scanner;
        }
        if (user == null) {
            return this.store.getCoprocessorHost().preCompact(this.store, scanner, scanType, request);
        }
        try {
            return (InternalScanner)user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<InternalScanner>(){

                @Override
                public InternalScanner run() throws Exception {
                    return Compactor.this.store.getCoprocessorHost().preCompact(Compactor.this.store, scanner, scanType, request);
                }
            });
        }
        catch (InterruptedException ie) {
            InterruptedIOException iioe = new InterruptedIOException();
            iioe.initCause(ie);
            throw iioe;
        }
    }

    private String generateCompactionName() {
        int next;
        int counter;
        while (!NAME_COUNTER.compareAndSet(counter, next = (counter = NAME_COUNTER.get()) == Integer.MAX_VALUE ? 0 : counter + 1)) {
        }
        return this.store.getRegionInfo().getRegionNameAsString() + "#" + this.store.getFamily().getNameAsString() + "#" + counter;
    }

    protected boolean performCompaction(InternalScanner scanner, CellSink writer, long smallestReadPoint, boolean cleanSeqId, CompactionThroughputController throughputController) throws IOException {
        long bytesWritten = 0L;
        long bytesWrittenProgress = 0L;
        ArrayList<Cell> cells = new ArrayList<Cell>();
        long closeCheckInterval = HStore.getCloseCheckInterval();
        long lastMillis = 0L;
        if (LOG.isDebugEnabled()) {
            lastMillis = EnvironmentEdgeManager.currentTime();
        }
        String compactionName = this.generateCompactionName();
        long now = 0L;
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
        throughputController.start(compactionName);
        try {
            boolean hasMore;
            do {
                hasMore = scanner.next(cells, scannerContext);
                if (LOG.isDebugEnabled()) {
                    now = EnvironmentEdgeManager.currentTime();
                }
                for (Cell c : cells) {
                    if (cleanSeqId && c.getSequenceId() <= smallestReadPoint) {
                        CellUtil.setSequenceId(c, 0L);
                    }
                    writer.append(c);
                    int len = KeyValueUtil.length(c);
                    ++this.progress.currentCompactedKVs;
                    this.progress.totalCompactedSize += (long)len;
                    if (LOG.isDebugEnabled()) {
                        bytesWrittenProgress += (long)len;
                    }
                    throughputController.control(compactionName, len);
                    if (closeCheckInterval <= 0L || (bytesWritten += (long)len) <= closeCheckInterval) continue;
                    bytesWritten = 0L;
                    if (this.store.areWritesEnabled()) continue;
                    this.progress.cancel();
                    boolean bl = false;
                    return bl;
                }
                if (LOG.isDebugEnabled() && now - lastMillis >= 60000L) {
                    LOG.debug((Object)("Compaction progress: " + compactionName + " " + this.progress + String.format(", rate=%.2f kB/sec", (double)bytesWrittenProgress / 1024.0 / ((double)(now - lastMillis) / 1000.0)) + ", throughputController is " + throughputController));
                    lastMillis = now;
                    bytesWrittenProgress = 0L;
                }
                cells.clear();
            } while (hasMore);
        }
        catch (InterruptedException e) {
            this.progress.cancel();
            throw new InterruptedIOException("Interrupted while control throughput of compacting " + compactionName);
        }
        finally {
            throughputController.finish(compactionName);
        }
        this.progress.complete();
        return true;
    }

    protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(store.getFamily().getMaxVersions());
        return new StoreScanner(store, store.getScanInfo(), scan, scanners, scanType, smallestReadPoint, earliestPutTs);
    }

    protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(store.getFamily().getMaxVersions());
        return new StoreScanner(store, store.getScanInfo(), scan, scanners, smallestReadPoint, earliestPutTs, dropDeletesFromRow, dropDeletesToRow);
    }

    protected static class FileDetails {
        public long maxKeyCount = 0L;
        public long earliestPutTs = Long.MAX_VALUE;
        public long maxSeqId = 0L;
        public long maxMVCCReadpoint = 0L;
        public int maxTagsLength = 0;
        public long minSeqIdToKeep = 0L;

        protected FileDetails() {
        }
    }

    public static interface CellSink {
        public void append(Cell var1) throws IOException;
    }
}

