/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.io.ImmutableBytesWritable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, Put> {
    public static final String OUTPUT_TABLE = "hbase.mapred.outputtable";

    public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        TableName tableName = TableName.valueOf(job.get(OUTPUT_TABLE));
        BufferedMutator mutator = null;
        Connection connection = ConnectionFactory.createConnection((Configuration)job);
        mutator = connection.getBufferedMutator(tableName);
        return new TableRecordWriter(mutator);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws FileAlreadyExistsException, InvalidJobConfException, IOException {
        String tableName = job.get(OUTPUT_TABLE);
        if (tableName == null) {
            throw new IOException("Must specify table name");
        }
    }

    protected static class TableRecordWriter
    implements RecordWriter<ImmutableBytesWritable, Put> {
        private BufferedMutator m_mutator;

        public TableRecordWriter(BufferedMutator mutator) throws IOException {
            this.m_mutator = mutator;
        }

        public void close(Reporter reporter) throws IOException {
            this.m_mutator.close();
        }

        public void write(ImmutableBytesWritable key, Put value) throws IOException {
            this.m_mutator.mutate(new Put(value));
        }
    }
}

