/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellComparator {
    byte[] row1 = Bytes.toBytes("row1");
    byte[] row2 = Bytes.toBytes("row2");
    byte[] row_1_0 = Bytes.toBytes("row10");
    byte[] fam1 = Bytes.toBytes("fam1");
    byte[] fam2 = Bytes.toBytes("fam2");
    byte[] fam_1_2 = Bytes.toBytes("fam12");
    byte[] qual1 = Bytes.toBytes("qual1");
    byte[] qual2 = Bytes.toBytes("qual2");
    byte[] val = Bytes.toBytes("val");

    @Test
    public void testCompareCells() {
        KeyValue kv1 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        KeyValue kv2 = new KeyValue(this.row2, this.fam1, this.qual1, this.val);
        Assert.assertTrue((CellComparator.compare(kv1, kv2, false) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam2, this.qual1, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        Assert.assertTrue((CellComparator.compareFamilies(kv1, kv2) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 2L, this.val);
        Assert.assertTrue((CellComparator.compare(kv1, kv2, false) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((CellComparator.compare(kv1, kv2, false) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam_1_2, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((CellComparator.compareCommonFamilyPrefix(kv1, kv2, 4) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row_1_0, this.fam_1_2, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((CellComparator.compareCommonRowPrefix(kv1, kv2, 4) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual2, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((CellComparator.compareCommonQualifierPrefix(kv1, kv2, 4) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        Assert.assertTrue((boolean)CellComparator.equals(kv1, kv2));
    }

    @Test
    public void testGetShortMidpoint() {
        Cell right;
        Cell mid;
        KeyValue.KVComparator comparator = new KeyValue.KVComparator();
        Cell left = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        Assert.assertTrue((CellComparator.compare(left, mid = CellComparator.getMidpoint(comparator, left, right = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("a"))), true) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare(mid, right, true) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        right = CellUtil.createCell(Bytes.toBytes("b"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        mid = CellComparator.getMidpoint(comparator, left, right);
        Assert.assertTrue((CellComparator.compare(left, mid, true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare(mid, right, true) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell(Bytes.toBytes("g"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        right = CellUtil.createCell(Bytes.toBytes("i"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        mid = CellComparator.getMidpoint(comparator, left, right);
        Assert.assertTrue((CellComparator.compare(left, mid, true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare(mid, right, true) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        right = CellUtil.createCell(Bytes.toBytes("bbbbbbb"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        mid = CellComparator.getMidpoint(comparator, left, right);
        Assert.assertTrue((CellComparator.compare(left, mid, true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare(mid, right, true) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)mid.getRowLength());
        left = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        right = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("b"), Bytes.toBytes("a"));
        mid = CellComparator.getMidpoint(comparator, left, right);
        Assert.assertTrue((CellComparator.compare(left, mid, true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare(mid, right, true) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        right = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("aaaaaaaa"), Bytes.toBytes("b"));
        mid = CellComparator.getMidpoint(comparator, left, right);
        Assert.assertTrue((CellComparator.compare(left, mid, true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare(mid, right, true) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)mid.getFamilyLength());
        left = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        right = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("aaaaaaaaa"));
        mid = CellComparator.getMidpoint(comparator, left, right);
        Assert.assertTrue((CellComparator.compare(left, mid, true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare(mid, right, true) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)mid.getQualifierLength());
        left = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        right = CellUtil.createCell(Bytes.toBytes("a"), Bytes.toBytes("a"), Bytes.toBytes("b"));
        mid = CellComparator.getMidpoint(comparator, left, right);
        Assert.assertTrue((CellComparator.compare(left, mid, true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare(mid, right, true) <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)mid.getQualifierLength());
        left = CellUtil.createCell(Bytes.toBytes("g"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        right = CellUtil.createCell(Bytes.toBytes("i"), Bytes.toBytes("a"), Bytes.toBytes("a"));
        mid = CellComparator.getMidpoint(new KeyValue.MetaComparator(), left, right);
        Assert.assertTrue((CellComparator.compare(left, mid, true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare(mid, right, true) == 0 ? 1 : 0) != 0);
    }
}

