/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;

public class HoodieHFileRecordReader
implements RecordReader<NullWritable, ArrayWritable> {
    private long count = 0L;
    private ArrayWritable valueObj;
    private HoodieHFileReader reader;
    private Iterator<GenericRecord> recordIterator;
    private Schema schema;

    public HoodieHFileRecordReader(Configuration conf, InputSplit split, JobConf job) throws IOException {
        FileSplit fileSplit = (FileSplit)split;
        Path path = fileSplit.getPath();
        this.reader = new HoodieHFileReader(conf, path, new CacheConfig(conf));
        this.schema = this.reader.getSchema();
        this.valueObj = new ArrayWritable(Writable.class, new Writable[this.schema.getFields().size()]);
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        if (this.recordIterator == null) {
            this.recordIterator = this.reader.getRecordIterator(this.schema);
        }
        if (!this.recordIterator.hasNext()) {
            return false;
        }
        GenericRecord record = this.recordIterator.next();
        ArrayWritable aWritable = (ArrayWritable)HoodieRealtimeRecordReaderUtils.avroToArrayWritable(record, this.schema);
        value.set(aWritable.get());
        ++this.count;
        return true;
    }

    public NullWritable createKey() {
        return null;
    }

    public ArrayWritable createValue() {
        return this.valueObj;
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public float getProgress() throws IOException {
        return 1.0f * (float)this.count / (float)this.reader.getTotalRecords();
    }
}

