/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Option;

public class HoodieTablePreCommitFileSystemView {
    private Map<String, List<String>> partitionToReplaceFileIds;
    private List<HoodieWriteStat> filesWritten;
    private String preCommitInstantTime;
    private SyncableFileSystemView completedCommitsFileSystemView;
    private HoodieTableMetaClient tableMetaClient;

    public HoodieTablePreCommitFileSystemView(HoodieTableMetaClient metaClient, SyncableFileSystemView completedCommitsFileSystemView, List<HoodieWriteStat> filesWritten, Map<String, List<String>> partitionToReplaceFileIds, String instantTime) {
        this.completedCommitsFileSystemView = completedCommitsFileSystemView;
        this.filesWritten = filesWritten;
        this.partitionToReplaceFileIds = partitionToReplaceFileIds;
        this.preCommitInstantTime = instantTime;
        this.tableMetaClient = metaClient;
    }

    public final Stream<HoodieBaseFile> getLatestBaseFiles(String partitionStr) {
        List replacedFileIdsForPartition = this.partitionToReplaceFileIds.getOrDefault(partitionStr, Collections.emptyList());
        Map<String, HoodieBaseFile> newFilesWrittenForPartition = this.filesWritten.stream().filter(file -> partitionStr.equals(file.getPartitionPath())).collect(Collectors.toMap(HoodieWriteStat::getFileId, writeStat -> new HoodieBaseFile(new Path(this.tableMetaClient.getBasePath(), writeStat.getPath()).toString())));
        Stream<HoodieBaseFile> committedBaseFiles = this.completedCommitsFileSystemView.getLatestBaseFiles(partitionStr);
        Stream<HoodieBaseFile> baseFilesForCommittedFileIds = committedBaseFiles.filter(baseFile -> !replacedFileIdsForPartition.contains(baseFile.getFileId())).map(baseFile -> {
            HoodieBaseFile fileIdNewVersionExists = (HoodieBaseFile)newFilesWrittenForPartition.remove(baseFile.getFileId());
            return Option.ofNullable(fileIdNewVersionExists).orElse((HoodieBaseFile)baseFile);
        });
        Stream<HoodieBaseFile> baseFilesWithNewFileIds = newFilesWrittenForPartition.values().stream();
        return Stream.concat(baseFilesForCommittedFileIds, baseFilesWithNewFileIds);
    }
}

