/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodiePartitionMetadata {
    public static final String HOODIE_PARTITION_METAFILE = ".hoodie_partition_metadata";
    public static final String PARTITION_DEPTH_KEY = "partitionDepth";
    public static final String COMMIT_TIME_KEY = "commitTime";
    private final Properties props;
    private final Path partitionPath;
    private final FileSystem fs;
    private static final Logger LOG = LogManager.getLogger(HoodiePartitionMetadata.class);

    public HoodiePartitionMetadata(FileSystem fs, Path partitionPath) {
        this.fs = fs;
        this.props = new Properties();
        this.partitionPath = partitionPath;
    }

    public HoodiePartitionMetadata(FileSystem fs, String instantTime, Path basePath, Path partitionPath) {
        this(fs, partitionPath);
        this.props.setProperty(COMMIT_TIME_KEY, instantTime);
        this.props.setProperty(PARTITION_DEPTH_KEY, String.valueOf(partitionPath.depth() - basePath.depth()));
    }

    public int getPartitionDepth() {
        if (!this.props.containsKey(PARTITION_DEPTH_KEY)) {
            throw new HoodieException("Could not find partitionDepth in partition metafile");
        }
        return Integer.parseInt(this.props.getProperty(PARTITION_DEPTH_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trySave(int taskPartitionId) {
        Path tmpMetaPath = new Path(this.partitionPath, ".hoodie_partition_metadata_" + taskPartitionId);
        Path metaPath = new Path(this.partitionPath, HOODIE_PARTITION_METAFILE);
        boolean metafileExists = false;
        try {
            metafileExists = this.fs.exists(metaPath);
            if (!metafileExists) {
                FSDataOutputStream os = this.fs.create(tmpMetaPath, true);
                this.props.store((OutputStream)os, "partition metadata");
                os.hsync();
                os.hflush();
                os.close();
                this.fs.rename(tmpMetaPath, metaPath);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error trying to save partition metadata (this is okay, as long as atleast 1 of these succced), " + this.partitionPath), (Throwable)ioe);
        }
        finally {
            if (!metafileExists) {
                try {
                    if (this.fs.exists(tmpMetaPath)) {
                        this.fs.delete(tmpMetaPath, false);
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Error trying to clean up temporary files for " + this.partitionPath), (Throwable)ioe);
                }
            }
        }
    }

    public void readFromFS() throws IOException {
        try (FSDataInputStream is = null;){
            Path metaFile = new Path(this.partitionPath, HOODIE_PARTITION_METAFILE);
            is = this.fs.open(metaFile);
            this.props.load((InputStream)is);
        }
    }

    public static boolean hasPartitionMetadata(FileSystem fs, Path partitionPath) {
        try {
            return fs.exists(new Path(partitionPath, HOODIE_PARTITION_METAFILE));
        }
        catch (IOException ioe) {
            throw new HoodieException("Error checking Hoodie partition metadata for " + partitionPath, ioe);
        }
    }
}

