/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common;

import java.io.Serializable;
import java.util.List;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;

public class HoodieCleanStat
implements Serializable {
    private final HoodieCleaningPolicy policy;
    private final String partitionPath;
    private final List<String> deletePathPatterns;
    private final List<String> successDeleteFiles;
    private final List<String> failedDeleteFiles;
    private final List<String> deleteBootstrapBasePathPatterns;
    private final List<String> successDeleteBootstrapBaseFiles;
    private final List<String> failedDeleteBootstrapBaseFiles;
    private final String earliestCommitToRetain;

    public HoodieCleanStat(HoodieCleaningPolicy policy, String partitionPath, List<String> deletePathPatterns, List<String> successDeleteFiles, List<String> failedDeleteFiles, String earliestCommitToRetain) {
        this(policy, partitionPath, deletePathPatterns, successDeleteFiles, failedDeleteFiles, earliestCommitToRetain, CollectionUtils.createImmutableList(new String[0]), CollectionUtils.createImmutableList(new String[0]), CollectionUtils.createImmutableList(new String[0]));
    }

    public HoodieCleanStat(HoodieCleaningPolicy policy, String partitionPath, List<String> deletePathPatterns, List<String> successDeleteFiles, List<String> failedDeleteFiles, String earliestCommitToRetain, List<String> deleteBootstrapBasePathPatterns, List<String> successDeleteBootstrapBaseFiles, List<String> failedDeleteBootstrapBaseFiles) {
        this.policy = policy;
        this.partitionPath = partitionPath;
        this.deletePathPatterns = deletePathPatterns;
        this.successDeleteFiles = successDeleteFiles;
        this.failedDeleteFiles = failedDeleteFiles;
        this.earliestCommitToRetain = earliestCommitToRetain;
        this.deleteBootstrapBasePathPatterns = deleteBootstrapBasePathPatterns;
        this.successDeleteBootstrapBaseFiles = successDeleteBootstrapBaseFiles;
        this.failedDeleteBootstrapBaseFiles = failedDeleteBootstrapBaseFiles;
    }

    public HoodieCleaningPolicy getPolicy() {
        return this.policy;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public List<String> getDeletePathPatterns() {
        return this.deletePathPatterns;
    }

    public List<String> getSuccessDeleteFiles() {
        return this.successDeleteFiles;
    }

    public List<String> getFailedDeleteFiles() {
        return this.failedDeleteFiles;
    }

    public List<String> getDeleteBootstrapBasePathPatterns() {
        return this.deleteBootstrapBasePathPatterns;
    }

    public List<String> getSuccessDeleteBootstrapBaseFiles() {
        return this.successDeleteBootstrapBaseFiles;
    }

    public List<String> getFailedDeleteBootstrapBaseFiles() {
        return this.failedDeleteBootstrapBaseFiles;
    }

    public String getEarliestCommitToRetain() {
        return this.earliestCommitToRetain;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "HoodieCleanStat{policy=" + (Object)((Object)this.policy) + ", partitionPath='" + this.partitionPath + '\'' + ", deletePathPatterns=" + this.deletePathPatterns + ", successDeleteFiles=" + this.successDeleteFiles + ", failedDeleteFiles=" + this.failedDeleteFiles + ", earliestCommitToRetain='" + this.earliestCommitToRetain + ", deleteBootstrapBasePathPatterns=" + this.deleteBootstrapBasePathPatterns + ", successDeleteBootstrapBaseFiles=" + this.successDeleteBootstrapBaseFiles + ", failedDeleteBootstrapBaseFiles=" + this.failedDeleteBootstrapBaseFiles + '\'' + '}';
    }

    public static class Builder {
        private HoodieCleaningPolicy policy;
        private List<String> deletePathPatterns;
        private List<String> successDeleteFiles;
        private List<String> failedDeleteFiles;
        private String partitionPath;
        private String earliestCommitToRetain;
        private List<String> deleteBootstrapBasePathPatterns;
        private List<String> successDeleteBootstrapBaseFiles;
        private List<String> failedDeleteBootstrapBaseFiles;

        public Builder withPolicy(HoodieCleaningPolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder withDeletePathPattern(List<String> deletePathPatterns) {
            this.deletePathPatterns = deletePathPatterns;
            return this;
        }

        public Builder withSuccessfulDeletes(List<String> successDeleteFiles) {
            this.successDeleteFiles = successDeleteFiles;
            return this;
        }

        public Builder withFailedDeletes(List<String> failedDeleteFiles) {
            this.failedDeleteFiles = failedDeleteFiles;
            return this;
        }

        public Builder withDeleteBootstrapBasePathPatterns(List<String> deletePathPatterns) {
            this.deleteBootstrapBasePathPatterns = deletePathPatterns;
            return this;
        }

        public Builder withSuccessfulDeleteBootstrapBaseFiles(List<String> successDeleteFiles) {
            this.successDeleteBootstrapBaseFiles = successDeleteFiles;
            return this;
        }

        public Builder withFailedDeleteBootstrapBaseFiles(List<String> failedDeleteFiles) {
            this.failedDeleteBootstrapBaseFiles = failedDeleteFiles;
            return this;
        }

        public Builder withPartitionPath(String partitionPath) {
            this.partitionPath = partitionPath;
            return this;
        }

        public Builder withEarliestCommitRetained(Option<HoodieInstant> earliestCommitToRetain) {
            this.earliestCommitToRetain = earliestCommitToRetain.isPresent() ? earliestCommitToRetain.get().getTimestamp() : "";
            return this;
        }

        public HoodieCleanStat build() {
            return new HoodieCleanStat(this.policy, this.partitionPath, this.deletePathPatterns, this.successDeleteFiles, this.failedDeleteFiles, this.earliestCommitToRetain, this.deleteBootstrapBasePathPatterns, this.successDeleteBootstrapBaseFiles, this.failedDeleteBootstrapBaseFiles);
        }
    }
}

