/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.hadoop.io.Writable;

public class AvroGenericRecordWritable
implements Writable {
    GenericRecord record;
    private BinaryDecoder binaryDecoder;

    public GenericRecord getRecord() {
        return this.record;
    }

    public void setRecord(GenericRecord record) {
        this.record = record;
    }

    public AvroGenericRecordWritable() {
    }

    public AvroGenericRecordWritable(GenericRecord record) {
        this.record = record;
    }

    public void write(DataOutput out) throws IOException {
        String schemaString = this.record.getSchema().toString(false);
        out.writeUTF(schemaString);
        GenericDatumWriter<GenericRecord> gdw = new GenericDatumWriter<GenericRecord>();
        BinaryEncoder be = EncoderFactory.get().directBinaryEncoder((DataOutputStream)out, null);
        gdw.setSchema(this.record.getSchema());
        gdw.write(this.record, be);
    }

    public void readFields(DataInput in) throws IOException {
        Schema schema = Schema.parse(in.readUTF());
        this.record = new GenericData.Record(schema);
        this.binaryDecoder = DecoderFactory.defaultFactory().createBinaryDecoder((InputStream)((Object)in), this.binaryDecoder);
        GenericDatumReader<GenericRecord> gdr = new GenericDatumReader<GenericRecord>(schema);
        this.record = gdr.read(this.record, this.binaryDecoder);
    }
}

