/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="log10", value="_FUNC_(x) - Returns the logarithm of x with base 10", extended="Example:\n  > SELECT _FUNC_(10) FROM src LIMIT 1;\n  1")
public class UDFLog10
extends UDF {
    private static double log10 = Math.log(10.0);
    private DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(DoubleWritable a) {
        if (a == null || a.get() <= 0.0) {
            return null;
        }
        this.result.set(Math.log(a.get()) / log10);
        return this.result;
    }
}

