/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationPeers {
    private final Configuration conf;
    private final ConcurrentMap<String, ReplicationPeerImpl> peerCache;
    private final ReplicationPeerStorage peerStorage;

    ReplicationPeers(ZKWatcher zookeeper, Configuration conf) {
        this.conf = conf;
        this.peerCache = new ConcurrentHashMap<String, ReplicationPeerImpl>();
        this.peerStorage = ReplicationStorageFactory.getReplicationPeerStorage(zookeeper, conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void init() throws ReplicationException {
        for (String peerId : this.peerStorage.listPeerIds()) {
            this.addPeer(peerId);
        }
    }

    @VisibleForTesting
    public ReplicationPeerStorage getPeerStorage() {
        return this.peerStorage;
    }

    public boolean addPeer(String peerId) throws ReplicationException {
        if (this.peerCache.containsKey(peerId)) {
            return false;
        }
        this.peerCache.put(peerId, this.createPeer(peerId));
        return true;
    }

    public void removePeer(String peerId) {
        this.peerCache.remove(peerId);
    }

    public ReplicationPeerImpl getPeer(String peerId) {
        return (ReplicationPeerImpl)this.peerCache.get(peerId);
    }

    public Set<String> getAllPeerIds() {
        return Collections.unmodifiableSet(this.peerCache.keySet());
    }

    public Map<String, ReplicationPeerImpl> getPeerCache() {
        return Collections.unmodifiableMap(this.peerCache);
    }

    public ReplicationPeer.PeerState refreshPeerState(String peerId) throws ReplicationException {
        ReplicationPeerImpl peer = (ReplicationPeerImpl)this.peerCache.get(peerId);
        if (peer == null) {
            throw new ReplicationException("Peer with id=" + peerId + " is not cached.");
        }
        peer.setPeerState(this.peerStorage.isPeerEnabled(peerId));
        return peer.getPeerState();
    }

    public ReplicationPeerConfig refreshPeerConfig(String peerId) throws ReplicationException {
        ReplicationPeerImpl peer = (ReplicationPeerImpl)this.peerCache.get(peerId);
        if (peer == null) {
            throw new ReplicationException("Peer with id=" + peerId + " is not cached.");
        }
        peer.setPeerConfig(this.peerStorage.getPeerConfig(peerId));
        return peer.getPeerConfig();
    }

    private ReplicationPeerImpl createPeer(String peerId) throws ReplicationException {
        ReplicationPeerConfig peerConfig = this.peerStorage.getPeerConfig(peerId);
        boolean enabled = this.peerStorage.isPeerEnabled(peerId);
        return new ReplicationPeerImpl(ReplicationUtils.getPeerClusterConfiguration(peerConfig, this.conf), peerId, enabled, peerConfig);
    }
}

