/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.DelayingRunner;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.ResultStatsUtil;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
class AsyncProcess {
    private static final Log LOG = LogFactory.getLog(AsyncProcess.class);
    protected static final AtomicLong COUNTER = new AtomicLong();
    public static final String PRIMARY_CALL_TIMEOUT_KEY = "hbase.client.primaryCallTimeout.multiget";
    public static final String START_LOG_ERRORS_AFTER_COUNT_KEY = "hbase.client.start.log.errors.counter";
    public static final int DEFAULT_START_LOG_ERRORS_AFTER_COUNT = 9;
    public static final String LOG_DETAILS_FOR_BATCH_ERROR = "hbase.client.log.batcherrors.details";
    private final int thresholdToLogUndoneTaskDetails;
    private static final String THRESHOLD_TO_LOG_UNDONE_TASK_DETAILS = "hbase.client.threshold.log.details";
    private static final int DEFAULT_THRESHOLD_TO_LOG_UNDONE_TASK_DETAILS = 10;
    private final int THRESHOLD_TO_LOG_REGION_DETAILS = 2;
    private static final AsyncRequestFuture NO_REQS_RESULT = new AsyncRequestFuture(){
        final Object[] result = new Object[0];

        @Override
        public boolean hasError() {
            return false;
        }

        @Override
        public RetriesExhaustedWithDetailsException getErrors() {
            return null;
        }

        @Override
        public List<? extends Row> getFailedOperations() {
            return null;
        }

        @Override
        public Object[] getResults() {
            return this.result;
        }

        @Override
        public void waitUntilDone() throws InterruptedIOException {
        }
    };
    protected final long id;
    protected final ClusterConnection connection;
    protected final RpcRetryingCallerFactory rpcCallerFactory;
    protected final RpcControllerFactory rpcFactory;
    protected final BatchErrors globalErrors;
    protected final ExecutorService pool;
    protected final AtomicLong tasksInProgress = new AtomicLong(0L);
    protected final ConcurrentMap<byte[], AtomicInteger> taskCounterPerRegion = new ConcurrentSkipListMap<byte[], AtomicInteger>(Bytes.BYTES_COMPARATOR);
    protected final ConcurrentMap<ServerName, AtomicInteger> taskCounterPerServer = new ConcurrentHashMap<ServerName, AtomicInteger>();
    private final int startLogErrorsCnt;
    protected final int maxTotalConcurrentTasks;
    protected final int maxConcurrentTasksPerRegion;
    protected final int maxConcurrentTasksPerServer;
    protected final long pause;
    protected int numTries;
    protected int serverTrackerTimeout;
    protected int timeout;
    protected long primaryCallTimeoutMicroseconds;

    public AsyncProcess(ClusterConnection hc, Configuration conf, ExecutorService pool, RpcRetryingCallerFactory rpcCaller, boolean useGlobalErrors, RpcControllerFactory rpcFactory) {
        if (hc == null) {
            throw new IllegalArgumentException("HConnection cannot be null.");
        }
        this.connection = hc;
        this.pool = pool;
        this.globalErrors = useGlobalErrors ? new BatchErrors() : null;
        this.id = COUNTER.incrementAndGet();
        this.pause = conf.getLong("hbase.client.pause", 100L);
        this.numTries = conf.getInt("hbase.client.retries.number", 31);
        this.timeout = conf.getInt("hbase.rpc.timeout", 60000);
        this.primaryCallTimeoutMicroseconds = conf.getInt(PRIMARY_CALL_TIMEOUT_KEY, 10000);
        this.maxTotalConcurrentTasks = conf.getInt("hbase.client.max.total.tasks", 100);
        this.maxConcurrentTasksPerServer = conf.getInt("hbase.client.max.perserver.tasks", 2);
        this.maxConcurrentTasksPerRegion = conf.getInt("hbase.client.max.perregion.tasks", 1);
        this.startLogErrorsCnt = conf.getInt(START_LOG_ERRORS_AFTER_COUNT_KEY, 9);
        if (this.maxTotalConcurrentTasks <= 0) {
            throw new IllegalArgumentException("maxTotalConcurrentTasks=" + this.maxTotalConcurrentTasks);
        }
        if (this.maxConcurrentTasksPerServer <= 0) {
            throw new IllegalArgumentException("maxConcurrentTasksPerServer=" + this.maxConcurrentTasksPerServer);
        }
        if (this.maxConcurrentTasksPerRegion <= 0) {
            throw new IllegalArgumentException("maxConcurrentTasksPerRegion=" + this.maxConcurrentTasksPerRegion);
        }
        this.serverTrackerTimeout = 0;
        for (int i = 0; i < this.numTries; ++i) {
            this.serverTrackerTimeout = (int)((long)this.serverTrackerTimeout + ConnectionUtils.getPauseTime(this.pause, i));
        }
        this.rpcCallerFactory = rpcCaller;
        this.rpcFactory = rpcFactory;
        this.thresholdToLogUndoneTaskDetails = conf.getInt(THRESHOLD_TO_LOG_UNDONE_TASK_DETAILS, 10);
    }

    private ExecutorService getPool(ExecutorService pool) {
        if (pool != null) {
            return pool;
        }
        if (this.pool != null) {
            return this.pool;
        }
        throw new RuntimeException("Neither AsyncProcess nor request have ExecutorService");
    }

    public <CResult> AsyncRequestFuture submit(TableName tableName, List<? extends Row> rows, boolean atLeastOne, Batch.Callback<CResult> callback, boolean needResults) throws InterruptedIOException {
        return this.submit(null, tableName, rows, atLeastOne, callback, needResults);
    }

    public <CResult> AsyncRequestFuture submit(ExecutorService pool, TableName tableName, List<? extends Row> rows, boolean atLeastOne, Batch.Callback<CResult> callback, boolean needResults) throws InterruptedIOException {
        if (rows.isEmpty()) {
            return NO_REQS_RESULT;
        }
        HashMap<ServerName, MultiAction<Row>> actionsByServer = new HashMap<ServerName, MultiAction<Row>>();
        ArrayList<Action<Row>> retainedActions = new ArrayList<Action<Row>>(rows.size());
        NonceGenerator ng = this.connection.getNonceGenerator();
        long nonceGroup = ng.getNonceGroup();
        ArrayList<Exception> locationErrors = null;
        ArrayList<Integer> locationErrorRows = null;
        block2: do {
            this.waitForMaximumCurrentTasks(this.maxTotalConcurrentTasks - 1, tableName.getNameAsString());
            HashMap<HRegionInfo, Boolean> regionIncluded = new HashMap<HRegionInfo, Boolean>();
            HashMap<ServerName, Boolean> serverIncluded = new HashMap<ServerName, Boolean>();
            int posInList = -1;
            Iterator<? extends Row> it = rows.iterator();
            while (it.hasNext()) {
                HRegionLocation loc;
                Row r = it.next();
                try {
                    if (r == null) {
                        throw new IllegalArgumentException("#" + this.id + ", row cannot be null");
                    }
                    RegionLocations locs = this.connection.locateRegion(tableName, r.getRow(), true, true, 0);
                    if (locs == null || locs.isEmpty() || locs.getDefaultRegionLocation() == null) {
                        throw new IOException("#" + this.id + ", no location found, aborting submit for" + " tableName=" + tableName + " rowkey=" + Bytes.toStringBinary((byte[])r.getRow()));
                    }
                    loc = locs.getDefaultRegionLocation();
                }
                catch (IOException ex) {
                    locationErrors = new ArrayList<Exception>();
                    locationErrorRows = new ArrayList<Integer>();
                    LOG.error((Object)"Failed to get region location ", (Throwable)ex);
                    retainedActions.add(new Action(r, ++posInList));
                    locationErrors.add(ex);
                    locationErrorRows.add(posInList);
                    it.remove();
                    continue block2;
                }
                if (!this.canTakeOperation(loc, regionIncluded, serverIncluded)) continue;
                Action<Row> action = new Action<Row>(r, ++posInList);
                AsyncProcess.setNonce(ng, r, action);
                retainedActions.add(action);
                byte[] regionName = loc.getRegionInfo().getRegionName();
                AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, nonceGroup);
                it.remove();
            }
        } while (retainedActions.isEmpty() && atLeastOne && locationErrors == null);
        if (retainedActions.isEmpty()) {
            return NO_REQS_RESULT;
        }
        return this.submitMultiActions(tableName, retainedActions, nonceGroup, callback, null, needResults, locationErrors, locationErrorRows, actionsByServer, pool);
    }

    <CResult> AsyncRequestFuture submitMultiActions(TableName tableName, List<Action<Row>> retainedActions, long nonceGroup, Batch.Callback<CResult> callback, Object[] results, boolean needResults, List<Exception> locationErrors, List<Integer> locationErrorRows, Map<ServerName, MultiAction<Row>> actionsByServer, ExecutorService pool) {
        AsyncRequestFutureImpl<CResult> ars = this.createAsyncRequestFuture(tableName, retainedActions, nonceGroup, pool, callback, results, needResults);
        if (locationErrors != null) {
            for (int i = 0; i < locationErrors.size(); ++i) {
                int originalIndex = locationErrorRows.get(i);
                Row row = retainedActions.get(originalIndex).getAction();
                ars.manageError(originalIndex, row, Retry.NO_LOCATION_PROBLEM, locationErrors.get(i), null);
            }
        }
        ((AsyncRequestFutureImpl)ars).sendMultiAction(actionsByServer, 1, null, false);
        return ars;
    }

    private static void addAction(ServerName server, byte[] regionName, Action<Row> action, Map<ServerName, MultiAction<Row>> actionsByServer, long nonceGroup) {
        MultiAction<Row> multiAction = actionsByServer.get(server);
        if (multiAction == null) {
            multiAction = new MultiAction();
            actionsByServer.put(server, multiAction);
        }
        if (action.hasNonce() && !multiAction.hasNonceGroup()) {
            multiAction.setNonceGroup(nonceGroup);
        }
        multiAction.add(regionName, action);
    }

    protected boolean canTakeOperation(HRegionLocation loc, Map<HRegionInfo, Boolean> regionsIncluded, Map<ServerName, Boolean> serversIncluded) {
        HRegionInfo regionInfo = loc.getRegionInfo();
        Boolean regionPrevious = regionsIncluded.get(regionInfo);
        if (regionPrevious != null) {
            return regionPrevious;
        }
        Boolean serverPrevious = serversIncluded.get(loc.getServerName());
        if (Boolean.FALSE.equals(serverPrevious)) {
            regionsIncluded.put(regionInfo, Boolean.FALSE);
            return false;
        }
        AtomicInteger regionCnt = (AtomicInteger)this.taskCounterPerRegion.get(loc.getRegionInfo().getRegionName());
        if (regionCnt != null && regionCnt.get() >= this.maxConcurrentTasksPerRegion) {
            regionsIncluded.put(regionInfo, Boolean.FALSE);
            return false;
        }
        if (serverPrevious == null) {
            boolean ok;
            int newServers = 0;
            for (Map.Entry<ServerName, Boolean> kv : serversIncluded.entrySet()) {
                if (!kv.getValue().booleanValue()) continue;
                ++newServers;
            }
            boolean bl = ok = (long)newServers + this.tasksInProgress.get() < (long)this.maxTotalConcurrentTasks;
            if (ok) {
                AtomicInteger serverCnt = (AtomicInteger)this.taskCounterPerServer.get(loc.getServerName());
                boolean bl2 = ok = serverCnt == null || serverCnt.get() < this.maxConcurrentTasksPerServer;
            }
            if (!ok) {
                regionsIncluded.put(regionInfo, Boolean.FALSE);
                serversIncluded.put(loc.getServerName(), Boolean.FALSE);
                return false;
            }
            serversIncluded.put(loc.getServerName(), Boolean.TRUE);
        } else assert (serverPrevious.equals(Boolean.TRUE));
        regionsIncluded.put(regionInfo, Boolean.TRUE);
        return true;
    }

    public <CResult> AsyncRequestFuture submitAll(TableName tableName, List<? extends Row> rows, Batch.Callback<CResult> callback, Object[] results) {
        return this.submitAll(null, tableName, rows, callback, results);
    }

    public <CResult> AsyncRequestFuture submitAll(ExecutorService pool, TableName tableName, List<? extends Row> rows, Batch.Callback<CResult> callback, Object[] results) {
        ArrayList<Action<Row>> actions = new ArrayList<Action<Row>>(rows.size());
        int posInList = -1;
        NonceGenerator ng = this.connection.getNonceGenerator();
        for (Row row : rows) {
            Put put;
            ++posInList;
            if (row instanceof Put && (put = (Put)row).isEmpty()) {
                throw new IllegalArgumentException("No columns to insert for #" + (posInList + 1) + " item");
            }
            Action<Row> action = new Action<Row>(row, posInList);
            AsyncProcess.setNonce(ng, row, action);
            actions.add(action);
        }
        AsyncRequestFutureImpl<CResult> ars = this.createAsyncRequestFuture(tableName, actions, ng.getNonceGroup(), this.getPool(pool), callback, results, results != null);
        ((AsyncRequestFutureImpl)ars).groupAndSendMultiAction(actions, 1);
        return ars;
    }

    private static void setNonce(NonceGenerator ng, Row r, Action<Row> action) {
        if (!(r instanceof Append) && !(r instanceof Increment)) {
            return;
        }
        action.setNonce(ng.newNonce());
    }

    @VisibleForTesting
    protected <CResult> AsyncRequestFutureImpl<CResult> createAsyncRequestFuture(TableName tableName, List<Action<Row>> actions, long nonceGroup, ExecutorService pool, Batch.Callback<CResult> callback, Object[] results, boolean needResults) {
        return new AsyncRequestFutureImpl<CResult>(tableName, actions, nonceGroup, this.getPool(pool), needResults, results, callback);
    }

    @VisibleForTesting
    protected MultiServerCallable<Row> createCallable(ServerName server, TableName tableName, MultiAction<Row> multi) {
        return new MultiServerCallable<Row>(this.connection, tableName, server, this.rpcFactory, multi);
    }

    @VisibleForTesting
    protected RpcRetryingCaller<MultiResponse> createCaller(MultiServerCallable<Row> callable) {
        return this.rpcCallerFactory.newCaller();
    }

    @VisibleForTesting
    void waitUntilDone() throws InterruptedIOException {
        this.waitForMaximumCurrentTasks(0, null);
    }

    private void waitForMaximumCurrentTasks(int max, String tableName) throws InterruptedIOException {
        this.waitForMaximumCurrentTasks(max, this.tasksInProgress, this.id, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void waitForMaximumCurrentTasks(int max, AtomicLong tasksInProgress, long id, String tableName) throws InterruptedIOException {
        long currentInProgress;
        long lastLog = EnvironmentEdgeManager.currentTime();
        long oldInProgress = Long.MAX_VALUE;
        while ((currentInProgress = tasksInProgress.get()) > (long)max) {
            long now2;
            if (oldInProgress != currentInProgress && (now2 = EnvironmentEdgeManager.currentTime()) > lastLog + 10000L) {
                lastLog = now2;
                LOG.info((Object)("#" + id + ", waiting for some tasks to finish. Expected max=" + max + ", tasksInProgress=" + currentInProgress + " hasError=" + this.hasError() + (tableName == null ? "" : ", tableName=" + tableName)));
                if (currentInProgress <= (long)this.thresholdToLogUndoneTaskDetails) {
                    this.logDetailsOfUndoneTasks(currentInProgress);
                }
            }
            oldInProgress = currentInProgress;
            try {
                AtomicLong now2 = tasksInProgress;
                synchronized (now2) {
                    if (tasksInProgress.get() == oldInProgress) {
                        tasksInProgress.wait(10L);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("#" + id + ", interrupted." + " currentNumberOfTask=" + currentInProgress);
            }
        }
    }

    private void logDetailsOfUndoneTasks(long taskInProgress) {
        ArrayList servers = new ArrayList();
        for (Map.Entry entry : this.taskCounterPerServer.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= 0) continue;
            servers.add(entry.getKey());
        }
        LOG.info((Object)("Left over " + taskInProgress + " task(s) are processed on server(s): " + servers));
        if (taskInProgress <= 2L) {
            ArrayList<String> regions = new ArrayList<String>();
            for (Map.Entry entry : this.taskCounterPerRegion.entrySet()) {
                if (((AtomicInteger)entry.getValue()).get() <= 0) continue;
                regions.add(Bytes.toString((byte[])((byte[])entry.getKey())));
            }
            LOG.info((Object)("Regions against which left over task(s) are processed: " + regions));
        }
    }

    public boolean hasError() {
        return this.globalErrors.hasErrors();
    }

    public RetriesExhaustedWithDetailsException waitForAllPreviousOpsAndReset(List<Row> failedRows, String tableName) throws InterruptedIOException {
        this.waitForMaximumCurrentTasks(0, tableName);
        if (!this.globalErrors.hasErrors()) {
            return null;
        }
        if (failedRows != null) {
            failedRows.addAll(this.globalErrors.actions);
        }
        RetriesExhaustedWithDetailsException result = this.globalErrors.makeException();
        this.globalErrors.clear();
        return result;
    }

    protected void incTaskCounters(Collection<byte[]> regions, ServerName sn) {
        this.tasksInProgress.incrementAndGet();
        AtomicInteger serverCnt = (AtomicInteger)this.taskCounterPerServer.get(sn);
        if (serverCnt == null) {
            this.taskCounterPerServer.putIfAbsent(sn, new AtomicInteger());
            serverCnt = (AtomicInteger)this.taskCounterPerServer.get(sn);
        }
        serverCnt.incrementAndGet();
        for (byte[] regBytes : regions) {
            AtomicInteger oldCnt;
            AtomicInteger regionCnt = (AtomicInteger)this.taskCounterPerRegion.get(regBytes);
            if (regionCnt == null && (oldCnt = this.taskCounterPerRegion.putIfAbsent(regBytes, regionCnt = new AtomicInteger())) != null) {
                regionCnt = oldCnt;
            }
            regionCnt.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decTaskCounters(Collection<byte[]> regions, ServerName sn) {
        for (byte[] regBytes : regions) {
            AtomicInteger regionCnt = (AtomicInteger)this.taskCounterPerRegion.get(regBytes);
            regionCnt.decrementAndGet();
        }
        ((AtomicInteger)this.taskCounterPerServer.get(sn)).decrementAndGet();
        this.tasksInProgress.decrementAndGet();
        AtomicLong atomicLong = this.tasksInProgress;
        synchronized (atomicLong) {
            this.tasksInProgress.notifyAll();
        }
    }

    protected ConnectionManager.ServerErrorTracker createServerErrorTracker() {
        return new ConnectionManager.ServerErrorTracker(this.serverTrackerTimeout, this.numTries);
    }

    private static boolean isReplicaGet(Row row) {
        return row instanceof Get && ((Get)row).getConsistency() == Consistency.TIMELINE;
    }

    private static enum Retry {
        YES,
        NO_LOCATION_PROBLEM,
        NO_NOT_RETRIABLE,
        NO_RETRIES_EXHAUSTED,
        NO_OTHER_SUCCEEDED;

    }

    protected class AsyncRequestFutureImpl<CResult>
    implements AsyncRequestFuture {
        private final Batch.Callback<CResult> callback;
        private final BatchErrors errors;
        private final ConnectionManager.ServerErrorTracker errorsByServer;
        private final ExecutorService pool;
        private final Set<MultiServerCallable<Row>> callsInProgress;
        private final TableName tableName;
        private final AtomicLong actionsInProgress = new AtomicLong(-1L);
        private final Object replicaResultLock = new Object();
        private final Object[] results;
        private final int[] replicaGetIndices;
        private final boolean hasAnyReplicaGets;
        private final long nonceGroup;

        public AsyncRequestFutureImpl(TableName tableName, List<Action<Row>> actions, long nonceGroup, ExecutorService pool, boolean needResults, Object[] results, Batch.Callback<CResult> callback) {
            this.pool = pool;
            this.callback = callback;
            this.nonceGroup = nonceGroup;
            this.tableName = tableName;
            this.actionsInProgress.set(actions.size());
            if (results != null) {
                assert (needResults);
                if (results.length != actions.size()) {
                    throw new AssertionError((Object)"results.length");
                }
                this.results = results;
                for (int i = 0; i != this.results.length; ++i) {
                    results[i] = null;
                }
            } else {
                this.results = needResults ? new Object[actions.size()] : null;
            }
            ArrayList<Integer> replicaGetIndices = null;
            boolean hasAnyReplicaGets = false;
            if (needResults) {
                boolean hasAnyNonReplicaReqs = false;
                int posInList = 0;
                for (Action<Row> action : actions) {
                    boolean isReplicaGet = AsyncProcess.isReplicaGet(action.getAction());
                    if (isReplicaGet) {
                        hasAnyReplicaGets = true;
                        if (hasAnyNonReplicaReqs) {
                            if (replicaGetIndices == null) {
                                replicaGetIndices = new ArrayList<Integer>(actions.size() - 1);
                            }
                            replicaGetIndices.add(posInList);
                        }
                    } else if (!hasAnyNonReplicaReqs) {
                        hasAnyNonReplicaReqs = true;
                        if (posInList > 0) {
                            replicaGetIndices = new ArrayList(actions.size() - 1);
                            for (int i = 0; i < posInList; ++i) {
                                replicaGetIndices.add(i);
                            }
                        }
                    }
                    ++posInList;
                }
            }
            this.hasAnyReplicaGets = hasAnyReplicaGets;
            if (replicaGetIndices != null) {
                this.replicaGetIndices = new int[replicaGetIndices.size()];
                int i = 0;
                for (Integer el : replicaGetIndices) {
                    this.replicaGetIndices[i++] = el;
                }
            } else {
                this.replicaGetIndices = null;
            }
            this.callsInProgress = !hasAnyReplicaGets ? null : Collections.newSetFromMap(new ConcurrentHashMap());
            this.errorsByServer = AsyncProcess.this.createServerErrorTracker();
            this.errors = AsyncProcess.this.globalErrors != null ? AsyncProcess.this.globalErrors : new BatchErrors();
        }

        @VisibleForTesting
        long getActionsInProgress() {
            return this.actionsInProgress.get();
        }

        public Set<MultiServerCallable<Row>> getCallsInProgress() {
            return this.callsInProgress;
        }

        private void groupAndSendMultiAction(List<Action<Row>> currentActions, int numAttempt) {
            boolean hasUnknown;
            byte[] regionName;
            HRegionLocation loc;
            HashMap<ServerName, MultiAction<Row>> actionsByServer = new HashMap<ServerName, MultiAction<Row>>();
            boolean isReplica = false;
            ArrayList<Action<Row>> unknownReplicaActions = null;
            for (Action<Row> action : currentActions) {
                boolean bl;
                RegionLocations locs = this.findAllLocationsOrFail(action, true);
                if (locs == null) continue;
                boolean bl2 = bl = !RegionReplicaUtil.isDefaultReplica(action.getReplicaId());
                if (isReplica && !bl) {
                    throw new AssertionError((Object)"Replica and non-replica actions in the same retry");
                }
                isReplica = bl;
                loc = locs.getRegionLocation(action.getReplicaId());
                if (loc == null || loc.getServerName() == null) {
                    if (isReplica) {
                        if (unknownReplicaActions == null) {
                            unknownReplicaActions = new ArrayList<Action<Row>>();
                        }
                        unknownReplicaActions.add(action);
                        continue;
                    }
                    this.manageLocationError(action, null);
                    continue;
                }
                regionName = loc.getRegionInfo().getRegionName();
                AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, this.nonceGroup);
            }
            boolean doStartReplica = numAttempt == 1 && !isReplica && this.hasAnyReplicaGets;
            boolean bl = hasUnknown = unknownReplicaActions != null && !unknownReplicaActions.isEmpty();
            if (!actionsByServer.isEmpty()) {
                this.sendMultiAction(actionsByServer, numAttempt, doStartReplica && !hasUnknown ? currentActions : null, numAttempt > 1 && !hasUnknown);
            }
            if (hasUnknown) {
                actionsByServer = new HashMap();
                for (Action action : unknownReplicaActions) {
                    loc = this.getReplicaLocationOrFail(action);
                    if (loc == null) continue;
                    regionName = loc.getRegionInfo().getRegionName();
                    AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, this.nonceGroup);
                }
                if (!actionsByServer.isEmpty()) {
                    this.sendMultiAction(actionsByServer, numAttempt, doStartReplica ? currentActions : null, true);
                }
            }
        }

        private HRegionLocation getReplicaLocationOrFail(Action<Row> action) {
            int replicaId = action.getReplicaId();
            RegionLocations locs = this.findAllLocationsOrFail(action, true);
            if (locs == null) {
                return null;
            }
            HRegionLocation loc = locs.getRegionLocation(replicaId);
            if (loc == null || loc.getServerName() == null) {
                locs = this.findAllLocationsOrFail(action, false);
                if (locs == null) {
                    return null;
                }
                loc = locs.getRegionLocation(replicaId);
            }
            if (loc == null || loc.getServerName() == null) {
                this.manageLocationError(action, null);
                return null;
            }
            return loc;
        }

        private void manageLocationError(Action<Row> action, Exception ex) {
            String msg = "Cannot get replica " + action.getReplicaId() + " location for " + action.getAction();
            LOG.error((Object)msg);
            if (ex == null) {
                ex = new IOException(msg);
            }
            this.manageError(action.getOriginalIndex(), action.getAction(), Retry.NO_LOCATION_PROBLEM, ex, null);
        }

        private RegionLocations findAllLocationsOrFail(Action<Row> action, boolean useCache) {
            if (action.getAction() == null) {
                throw new IllegalArgumentException("#" + AsyncProcess.this.id + ", row cannot be null");
            }
            RegionLocations loc = null;
            try {
                loc = AsyncProcess.this.connection.locateRegion(this.tableName, action.getAction().getRow(), useCache, true, action.getReplicaId());
            }
            catch (IOException ex) {
                this.manageLocationError(action, ex);
            }
            return loc;
        }

        private void sendMultiAction(Map<ServerName, MultiAction<Row>> actionsByServer, int numAttempt, List<Action<Row>> actionsForReplicaThread, boolean reuseThread) {
            int actionsRemaining = actionsByServer.size();
            for (Map.Entry<ServerName, MultiAction<Row>> e : actionsByServer.entrySet()) {
                ServerName server = e.getKey();
                MultiAction<Row> multiAction = e.getValue();
                AsyncProcess.this.incTaskCounters(multiAction.getRegions(), server);
                Collection<Runnable> runnables = this.getNewMultiActionRunnable(server, multiAction, numAttempt);
                if (runnables.size() > actionsRemaining) {
                    actionsRemaining = runnables.size();
                }
                for (Runnable runnable : runnables) {
                    if (--actionsRemaining == 0 && reuseThread) {
                        runnable.run();
                        continue;
                    }
                    try {
                        this.pool.submit(runnable);
                    }
                    catch (Throwable t) {
                        if (t instanceof RejectedExecutionException) {
                            LOG.warn((Object)("#" + AsyncProcess.this.id + ", the task was rejected by the pool. This is unexpected." + " Server is " + server.getServerName()), t);
                        } else {
                            LOG.warn((Object)"Caught unexpected exception/error: ", t);
                        }
                        AsyncProcess.this.decTaskCounters(multiAction.getRegions(), server);
                        this.receiveGlobalFailure(multiAction, server, numAttempt, t);
                    }
                }
            }
            if (actionsForReplicaThread != null) {
                this.startWaitingForReplicaCalls(actionsForReplicaThread);
            }
        }

        private Collection<? extends Runnable> getNewMultiActionRunnable(ServerName server, MultiAction<Row> multiAction, int numAttempt) {
            if (AsyncProcess.this.connection.getStatisticsTracker() == null) {
                if (AsyncProcess.this.connection.getConnectionMetrics() != null) {
                    AsyncProcess.this.connection.getConnectionMetrics().incrNormalRunners();
                }
                return Collections.singletonList(Trace.wrap((String)"AsyncProcess.sendMultiAction", (Runnable)new SingleServerRequestRunnable(multiAction, numAttempt, server, this.callsInProgress)));
            }
            HashMap actions = new HashMap(multiAction.size());
            for (Map.Entry entry : multiAction.actions.entrySet()) {
                Long backoff = this.getBackoff(server, entry.getKey());
                DelayingRunner runner = (DelayingRunner)actions.get(backoff);
                if (runner == null) {
                    actions.put(backoff, new DelayingRunner(backoff, entry));
                    continue;
                }
                runner.add(entry);
            }
            ArrayList<SingleServerRequestRunnable> toReturn = new ArrayList<SingleServerRequestRunnable>(actions.size());
            for (DelayingRunner runner : actions.values()) {
                String traceText = "AsyncProcess.sendMultiAction";
                Runnable runnable = new SingleServerRequestRunnable(runner.getActions(), numAttempt, server, this.callsInProgress);
                if (runner.getSleepTime() > 0L) {
                    runner.setRunner(runnable);
                    traceText = "AsyncProcess.clientBackoff.sendMultiAction";
                    runnable = runner;
                    if (AsyncProcess.this.connection.getConnectionMetrics() != null) {
                        AsyncProcess.this.connection.getConnectionMetrics().incrDelayRunners();
                        AsyncProcess.this.connection.getConnectionMetrics().updateDelayInterval(runner.getSleepTime());
                    }
                } else if (AsyncProcess.this.connection.getConnectionMetrics() != null) {
                    AsyncProcess.this.connection.getConnectionMetrics().incrNormalRunners();
                }
                runnable = Trace.wrap((String)traceText, (Runnable)runnable);
                toReturn.add((SingleServerRequestRunnable)runnable);
            }
            return toReturn;
        }

        private Long getBackoff(ServerName server, byte[] regionName) {
            ServerStatisticTracker tracker = AsyncProcess.this.connection.getStatisticsTracker();
            ServerStatistics stats = tracker.getStats(server);
            return AsyncProcess.this.connection.getBackoffPolicy().getBackoffTime(server, regionName, stats);
        }

        private void startWaitingForReplicaCalls(List<Action<Row>> actionsForReplicaThread) {
            long startTime = EnvironmentEdgeManager.currentTime();
            ReplicaCallIssuingRunnable replicaRunnable = new ReplicaCallIssuingRunnable(actionsForReplicaThread, startTime);
            if (AsyncProcess.this.primaryCallTimeoutMicroseconds == 0L) {
                replicaRunnable.run();
            } else {
                try {
                    this.pool.submit(replicaRunnable);
                }
                catch (RejectedExecutionException ree) {
                    LOG.warn((Object)("#" + AsyncProcess.this.id + ", replica task was rejected by the pool - no replica calls"), (Throwable)ree);
                }
            }
        }

        public Retry manageError(int originalIndex, Row row, Retry canRetry, Throwable throwable, ServerName server) {
            if (canRetry == Retry.YES && throwable != null && (throwable instanceof DoNotRetryIOException || throwable instanceof NeedUnmanagedConnectionException)) {
                canRetry = Retry.NO_NOT_RETRIABLE;
            }
            if (canRetry != Retry.YES) {
                this.setError(originalIndex, row, throwable, server);
            } else if (this.isActionComplete(originalIndex, row)) {
                canRetry = Retry.NO_OTHER_SUCCEEDED;
            }
            return canRetry;
        }

        private void receiveGlobalFailure(MultiAction<Row> rsActions, ServerName server, int numAttempt, Throwable t) {
            Retry canRetry;
            this.errorsByServer.reportServerError(server);
            Retry retry = canRetry = this.errorsByServer.canRetryMore(numAttempt) ? Retry.YES : Retry.NO_RETRIES_EXHAUSTED;
            if (this.tableName == null) {
                AsyncProcess.this.connection.clearCaches(server);
            }
            int failed = 0;
            int stopped = 0;
            ArrayList<Action<Row>> toReplay = new ArrayList<Action<Row>>();
            for (Map.Entry e : rsActions.actions.entrySet()) {
                byte[] regionName = e.getKey();
                byte[] row = e.getValue().iterator().next().getAction().getRow();
                if (this.tableName != null) {
                    AsyncProcess.this.connection.updateCachedLocations(this.tableName, regionName, row, ClientExceptionsUtil.isMetaClearingException(t) ? null : t, server);
                }
                for (Action action : e.getValue()) {
                    Retry retry2 = this.manageError(action.getOriginalIndex(), action.getAction(), canRetry, t, server);
                    if (retry2 == Retry.YES) {
                        toReplay.add(action);
                        continue;
                    }
                    if (retry2 == Retry.NO_OTHER_SUCCEEDED) {
                        ++stopped;
                        continue;
                    }
                    ++failed;
                }
            }
            if (toReplay.isEmpty()) {
                this.logNoResubmit(server, numAttempt, rsActions.size(), t, failed, stopped);
            } else {
                this.resubmit(server, toReplay, numAttempt, rsActions.size(), t);
            }
        }

        private void resubmit(ServerName oldServer, List<Action<Row>> toReplay, int numAttempt, int failureCount, Throwable throwable) {
            long backOffTime;
            boolean retryImmediately = throwable instanceof RetryImmediatelyException;
            int nextAttemptNumber = retryImmediately ? numAttempt : numAttempt + 1;
            long l = backOffTime = retryImmediately ? 0L : this.errorsByServer.calculateBackoffTime(oldServer, AsyncProcess.this.pause);
            if (numAttempt > AsyncProcess.this.startLogErrorsCnt) {
                LOG.info((Object)this.createLog(numAttempt, failureCount, toReplay.size(), oldServer, throwable, backOffTime, true, null, -1, -1));
            }
            try {
                if (backOffTime > 0L) {
                    Thread.sleep(backOffTime);
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("#" + AsyncProcess.this.id + ", not sent: " + toReplay.size() + " operations, " + oldServer), (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
            this.groupAndSendMultiAction(toReplay, nextAttemptNumber);
        }

        private void logNoResubmit(ServerName oldServer, int numAttempt, int failureCount, Throwable throwable, int failed, int stopped) {
            if (failureCount != 0 || numAttempt > AsyncProcess.this.startLogErrorsCnt + 1) {
                String timeStr = new Date(this.errorsByServer.getStartTrackingTime()).toString();
                String logMessage = this.createLog(numAttempt, failureCount, 0, oldServer, throwable, -1L, false, timeStr, failed, stopped);
                if (failed != 0) {
                    LOG.warn((Object)logMessage);
                } else {
                    LOG.info((Object)logMessage);
                }
            }
        }

        private void receiveMultiAction(MultiAction<Row> multiAction, ServerName server, MultiResponse responses, int numAttempt) {
            assert (responses != null);
            ArrayList<Action<Row>> toReplay = new ArrayList<Action<Row>>();
            Throwable throwable = null;
            int failureCount = 0;
            Retry canRetry = null;
            Map<byte[], Map<Integer, Object>> results = responses.getResults();
            int failed = 0;
            int stopped = 0;
            for (Map.Entry regionEntry : multiAction.actions.entrySet()) {
                byte[] regionName = regionEntry.getKey();
                Throwable regionException = responses.getExceptions().get(regionName);
                if (this.tableName == null && ClientExceptionsUtil.isMetaClearingException(regionException)) {
                    AsyncProcess.this.connection.clearCaches(server);
                }
                Map<Object, Object> regionResults = results.containsKey(regionName) ? results.get(regionName) : Collections.emptyMap();
                boolean regionFailureRegistered = false;
                for (Action<Row> action : regionEntry.getValue()) {
                    Object result = regionResults.get(action.getOriginalIndex());
                    if (result == null) {
                        if (regionException == null) {
                            LOG.error((Object)("Server sent us neither results nor exceptions for " + Bytes.toStringBinary((byte[])regionName) + ", numAttempt:" + numAttempt));
                            regionException = new RuntimeException("Invalid response");
                        }
                        result = regionException;
                    }
                    if (result instanceof Throwable) {
                        Row row = action.getAction();
                        Throwable throwable2 = throwable = regionException != null ? regionException : ClientExceptionsUtil.findException(result);
                        if (!regionFailureRegistered) {
                            regionFailureRegistered = true;
                            AsyncProcess.this.connection.updateCachedLocations(this.tableName, regionName, row.getRow(), result, server);
                        }
                        if (canRetry == null) {
                            this.errorsByServer.reportServerError(server);
                            canRetry = this.errorsByServer.canRetryMore(numAttempt) ? Retry.YES : Retry.NO_RETRIES_EXHAUSTED;
                        }
                        ++failureCount;
                        switch (this.manageError(action.getOriginalIndex(), row, canRetry, (Throwable)result, server)) {
                            case YES: {
                                toReplay.add(action);
                                break;
                            }
                            case NO_OTHER_SUCCEEDED: {
                                ++stopped;
                                break;
                            }
                            default: {
                                ++failed;
                                break;
                            }
                        }
                        continue;
                    }
                    if (AsyncProcess.this.connection.getConnectionMetrics() != null) {
                        AsyncProcess.this.connection.getConnectionMetrics().updateServerStats(server, regionName, result);
                    }
                    if (AsyncProcess.this.connection.getStatisticsTracker() != null) {
                        result = ResultStatsUtil.updateStats(result, AsyncProcess.this.connection.getStatisticsTracker(), server, regionName);
                    }
                    if (this.callback != null) {
                        try {
                            this.callback.update(regionName, action.getAction().getRow(), result);
                        }
                        catch (Throwable t) {
                            LOG.error((Object)("User callback threw an exception for " + Bytes.toStringBinary((byte[])regionName) + ", ignoring"), t);
                        }
                    }
                    this.setResult(action, result);
                }
            }
            if (toReplay.isEmpty()) {
                this.logNoResubmit(server, numAttempt, failureCount, throwable, failed, stopped);
            } else {
                this.resubmit(server, toReplay, numAttempt, failureCount, throwable);
            }
        }

        private String createLog(int numAttempt, int failureCount, int replaySize, ServerName sn, Throwable error, long backOffTime, boolean willRetry, String startTime, int failed, int stopped) {
            StringBuilder sb = new StringBuilder();
            sb.append("#").append(AsyncProcess.this.id).append(", table=").append(this.tableName).append(", ").append("attempt=").append(numAttempt).append("/").append(AsyncProcess.this.numTries).append(" ");
            if (failureCount > 0 || error != null) {
                sb.append("failed=").append(failureCount).append("ops").append(", last exception: ").append(error == null ? "null" : error);
            } else {
                sb.append("succeeded");
            }
            sb.append(" on ").append(sn).append(", tracking started ").append(startTime);
            if (willRetry) {
                sb.append(", retrying after=").append(backOffTime).append("ms").append(", replay=").append(replaySize).append("ops");
            } else if (failureCount > 0) {
                if (stopped > 0) {
                    sb.append("; not retrying ").append(stopped).append(" due to success from other replica");
                }
                if (failed > 0) {
                    sb.append("; not retrying ").append(failed).append(" - final failure");
                }
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setResult(Action<Row> action, Object result) {
            if (result == null) {
                throw new RuntimeException("Result cannot be null");
            }
            ReplicaResultState state = null;
            boolean isStale = !RegionReplicaUtil.isDefaultReplica(action.getReplicaId());
            int index = action.getOriginalIndex();
            if (this.results == null) {
                this.decActionCounter(index);
                return;
            }
            state = this.trySetResultSimple(index, action.getAction(), false, result, null, isStale);
            if (state == null) {
                return;
            }
            assert (state != null);
            Object object = state;
            synchronized (object) {
                if (state.callCount == 0) {
                    return;
                }
                state.callCount = 0;
            }
            object = this.replicaResultLock;
            synchronized (object) {
                if (this.results[index] != state) {
                    throw new AssertionError((Object)"We set the callCount but someone else replaced the result");
                }
                this.results[index] = result;
            }
            this.decActionCounter(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setError(int index, Row row, Throwable throwable, ServerName server) {
            ReplicaResultState state = null;
            if (this.results == null) {
                this.errors.add(throwable, row, server);
                this.decActionCounter(index);
                return;
            }
            state = this.trySetResultSimple(index, row, true, throwable, server, false);
            if (state == null) {
                return;
            }
            assert (state != null);
            BatchErrors target = null;
            boolean isActionDone = false;
            Object object = state;
            synchronized (object) {
                switch (state.callCount) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        target = this.errors;
                        isActionDone = true;
                        break;
                    }
                    default: {
                        assert (state.callCount > 1);
                        if (state.replicaErrors == null) {
                            state.replicaErrors = new BatchErrors();
                        }
                        target = state.replicaErrors;
                    }
                }
                --state.callCount;
            }
            target.add(throwable, row, server);
            if (isActionDone) {
                if (state.replicaErrors != null) {
                    this.errors.merge(state.replicaErrors);
                }
                object = this.replicaResultLock;
                synchronized (object) {
                    if (this.results[index] != state) {
                        throw new AssertionError((Object)"We set the callCount but someone else replaced the result");
                    }
                    this.results[index] = throwable;
                }
                this.decActionCounter(index);
            }
        }

        private boolean isActionComplete(int index, Row row) {
            if (!AsyncProcess.isReplicaGet(row)) {
                return false;
            }
            Object resObj = this.results[index];
            return resObj != null && (!(resObj instanceof ReplicaResultState) || ((ReplicaResultState)resObj).callCount == 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReplicaResultState trySetResultSimple(int index, Row row, boolean isError, Object result, ServerName server, boolean isFromReplica) {
            ReplicaResultState rrs;
            Object resObj = null;
            if (!AsyncProcess.isReplicaGet(row)) {
                if (isFromReplica) {
                    throw new AssertionError((Object)("Unexpected stale result for " + row));
                }
                this.results[index] = result;
            } else {
                Object object = this.replicaResultLock;
                synchronized (object) {
                    resObj = this.results[index];
                    if (resObj == null) {
                        if (isFromReplica) {
                            throw new AssertionError((Object)("Unexpected stale result for " + row));
                        }
                        this.results[index] = result;
                    }
                }
            }
            ReplicaResultState replicaResultState = rrs = resObj instanceof ReplicaResultState ? (ReplicaResultState)resObj : null;
            if (rrs == null && isError) {
                this.errors.add((Throwable)result, row, server);
            }
            if (resObj == null) {
                this.decActionCounter(index);
                return null;
            }
            return rrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decActionCounter(int index) {
            long actionsRemaining = this.actionsInProgress.decrementAndGet();
            if (actionsRemaining < 0L) {
                String error = this.buildDetailedErrorMsg("Incorrect actions in progress", index);
                throw new AssertionError((Object)error);
            }
            if (actionsRemaining == 0L) {
                AtomicLong atomicLong = this.actionsInProgress;
                synchronized (atomicLong) {
                    this.actionsInProgress.notifyAll();
                }
            }
        }

        private String buildDetailedErrorMsg(String string, int index) {
            int i;
            StringBuilder error = new StringBuilder(string);
            error.append("; called for ").append(index).append(", actionsInProgress ").append(this.actionsInProgress.get()).append("; replica gets: ");
            if (this.replicaGetIndices != null) {
                for (i = 0; i < this.replicaGetIndices.length; ++i) {
                    error.append(this.replicaGetIndices[i]).append(", ");
                }
            } else {
                error.append(this.hasAnyReplicaGets ? "all" : "none");
            }
            error.append("; results ");
            if (this.results != null) {
                for (i = 0; i < this.results.length; ++i) {
                    Object o = this.results[i];
                    error.append(o == null ? "null" : o.toString()).append(", ");
                }
            }
            return error.toString();
        }

        @Override
        public void waitUntilDone() throws InterruptedIOException {
            try {
                this.waitUntilDone(Long.MAX_VALUE);
            }
            catch (InterruptedException iex) {
                throw new InterruptedIOException(iex.getMessage());
            }
            finally {
                if (this.callsInProgress != null) {
                    for (MultiServerCallable<Row> clb : this.callsInProgress) {
                        clb.cancel();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitUntilDone(long cutoff) throws InterruptedException {
            long currentInProgress;
            boolean hasWait = cutoff != Long.MAX_VALUE;
            long lastLog = EnvironmentEdgeManager.currentTime();
            while (0L != (currentInProgress = this.actionsInProgress.get())) {
                long now = EnvironmentEdgeManager.currentTime();
                if (hasWait && now * 1000L > cutoff) {
                    return false;
                }
                if (!hasWait && now > lastLog + 10000L) {
                    lastLog = now;
                    LOG.info((Object)("#" + AsyncProcess.this.id + ", waiting for " + currentInProgress + "  actions to finish on table: " + this.tableName));
                    if (currentInProgress <= (long)AsyncProcess.this.thresholdToLogUndoneTaskDetails) {
                        AsyncProcess.this.logDetailsOfUndoneTasks(currentInProgress);
                    }
                }
                AtomicLong atomicLong = this.actionsInProgress;
                synchronized (atomicLong) {
                    if (this.actionsInProgress.get() == 0L) {
                        break;
                    }
                    if (!hasWait) {
                        this.actionsInProgress.wait(10L);
                    } else {
                        long waitMicroSecond = Math.min(100000L, cutoff - now * 1000L);
                        TimeUnit.MICROSECONDS.timedWait(this.actionsInProgress, waitMicroSecond);
                    }
                }
            }
            return true;
        }

        @Override
        public boolean hasError() {
            return this.errors.hasErrors();
        }

        @Override
        public List<? extends Row> getFailedOperations() {
            return this.errors.actions;
        }

        @Override
        public RetriesExhaustedWithDetailsException getErrors() {
            return this.errors.makeException();
        }

        @Override
        public Object[] getResults() throws InterruptedIOException {
            this.waitUntilDone();
            return this.results;
        }

        private final class SingleServerRequestRunnable
        implements Runnable {
            private final MultiAction<Row> multiAction;
            private final int numAttempt;
            private final ServerName server;
            private final Set<MultiServerCallable<Row>> callsInProgress;

            private SingleServerRequestRunnable(MultiAction<Row> multiAction, int numAttempt, ServerName server, Set<MultiServerCallable<Row>> callsInProgress) {
                this.multiAction = multiAction;
                this.numAttempt = numAttempt;
                this.server = server;
                this.callsInProgress = callsInProgress;
            }

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                block15: {
                    MultiServerCallable<Row> callable = null;
                    try {
                        MultiResponse res;
                        callable = AsyncProcess.this.createCallable(this.server, AsyncRequestFutureImpl.this.tableName, this.multiAction);
                        try {
                            RpcRetryingCaller<MultiResponse> caller = AsyncProcess.this.createCaller(callable);
                            if (this.callsInProgress != null) {
                                this.callsInProgress.add(callable);
                            }
                            if ((res = caller.callWithoutRetries(callable, AsyncProcess.this.timeout)) == null) {
                                return;
                            }
                        }
                        catch (IOException e) {
                            AsyncRequestFutureImpl.this.receiveGlobalFailure(this.multiAction, this.server, this.numAttempt, e);
                            return;
                        }
                        catch (Throwable t) {
                            block14: {
                                LOG.error((Object)("#" + AsyncProcess.this.id + ", Caught throwable while calling. This is unexpected." + " Retrying. Server is " + this.server + ", tableName=" + AsyncRequestFutureImpl.this.tableName), t);
                                AsyncRequestFutureImpl.this.receiveGlobalFailure(this.multiAction, this.server, this.numAttempt, t);
                                AsyncProcess.this.decTaskCounters(this.multiAction.getRegions(), this.server);
                                if (this.callsInProgress == null || callable == null) break block14;
                                this.callsInProgress.remove(callable);
                            }
                            return;
                        }
                        AsyncRequestFutureImpl.this.receiveMultiAction(this.multiAction, this.server, res, this.numAttempt);
                        break block15;
                        {
                            catch (Throwable t) {
                                LOG.error((Object)("Internal AsyncProcess #" + AsyncProcess.this.id + " error for " + AsyncRequestFutureImpl.this.tableName + " processing for " + this.server), t);
                                throw new RuntimeException(t);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        AsyncProcess.this.decTaskCounters(this.multiAction.getRegions(), this.server);
                        if (this.callsInProgress != null && callable != null) {
                            this.callsInProgress.remove(callable);
                        }
                    }
                }
            }
        }

        private final class ReplicaCallIssuingRunnable
        implements Runnable {
            private final long startTime;
            private final List<Action<Row>> initialActions;

            public ReplicaCallIssuingRunnable(List<Action<Row>> initialActions, long startTime) {
                this.initialActions = initialActions;
                this.startTime = startTime;
            }

            @Override
            public void run() {
                boolean done = false;
                if (AsyncProcess.this.primaryCallTimeoutMicroseconds > 0L) {
                    try {
                        done = AsyncRequestFutureImpl.this.waitUntilDone(this.startTime * 1000L + AsyncProcess.this.primaryCallTimeoutMicroseconds);
                    }
                    catch (InterruptedException ex) {
                        LOG.error((Object)("Replica thread was interrupted - no replica calls: " + ex.getMessage()));
                        return;
                    }
                }
                if (done) {
                    return;
                }
                HashMap<ServerName, MultiAction<Row>> actionsByServer = new HashMap<ServerName, MultiAction<Row>>();
                ArrayList<Action<Row>> unknownLocActions = new ArrayList<Action<Row>>();
                if (AsyncRequestFutureImpl.this.replicaGetIndices == null) {
                    for (int i = 0; i < AsyncRequestFutureImpl.this.results.length; ++i) {
                        this.addReplicaActions(i, actionsByServer, unknownLocActions);
                    }
                } else {
                    for (int replicaGetIndice : AsyncRequestFutureImpl.this.replicaGetIndices) {
                        this.addReplicaActions(replicaGetIndice, actionsByServer, unknownLocActions);
                    }
                }
                if (!actionsByServer.isEmpty()) {
                    AsyncRequestFutureImpl.this.sendMultiAction(actionsByServer, 1, null, unknownLocActions.isEmpty());
                }
                if (!unknownLocActions.isEmpty()) {
                    actionsByServer = new HashMap();
                    for (Action action : unknownLocActions) {
                        this.addReplicaActionsAgain(action, actionsByServer);
                    }
                    if (!actionsByServer.isEmpty()) {
                        AsyncRequestFutureImpl.this.sendMultiAction(actionsByServer, 1, null, true);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addReplicaActions(int index, Map<ServerName, MultiAction<Row>> actionsByServer, List<Action<Row>> unknownReplicaActions) {
                if (AsyncRequestFutureImpl.this.results[index] != null) {
                    return;
                }
                Action<Row> action = this.initialActions.get(index);
                RegionLocations loc = AsyncRequestFutureImpl.this.findAllLocationsOrFail(action, true);
                if (loc == null) {
                    return;
                }
                HRegionLocation[] locs = loc.getRegionLocations();
                if (locs.length == 1) {
                    LOG.warn((Object)("No replicas found for " + action.getAction()));
                    return;
                }
                Object object = AsyncRequestFutureImpl.this.replicaResultLock;
                synchronized (object) {
                    if (AsyncRequestFutureImpl.this.results[index] != null) {
                        return;
                    }
                    ((AsyncRequestFutureImpl)AsyncRequestFutureImpl.this).results[index] = new ReplicaResultState(locs.length);
                }
                for (int i = 1; i < locs.length; ++i) {
                    Action<Row> replicaAction = new Action<Row>(action, i);
                    if (locs[i] != null) {
                        AsyncProcess.addAction(locs[i].getServerName(), locs[i].getRegionInfo().getRegionName(), replicaAction, actionsByServer, AsyncRequestFutureImpl.this.nonceGroup);
                        continue;
                    }
                    unknownReplicaActions.add(replicaAction);
                }
            }

            private void addReplicaActionsAgain(Action<Row> action, Map<ServerName, MultiAction<Row>> actionsByServer) {
                if (action.getReplicaId() == 0) {
                    throw new AssertionError((Object)"Cannot have default replica here");
                }
                HRegionLocation loc = AsyncRequestFutureImpl.this.getReplicaLocationOrFail(action);
                if (loc == null) {
                    return;
                }
                AsyncProcess.addAction(loc.getServerName(), loc.getRegionInfo().getRegionName(), action, actionsByServer, AsyncRequestFutureImpl.this.nonceGroup);
            }
        }
    }

    protected static class BatchErrors {
        private final List<Throwable> throwables = new ArrayList<Throwable>();
        private final List<Row> actions = new ArrayList<Row>();
        private final List<String> addresses = new ArrayList<String>();

        protected BatchErrors() {
        }

        public synchronized void add(Throwable ex, Row row, ServerName serverName) {
            if (row == null) {
                throw new IllegalArgumentException("row cannot be null. location=" + serverName);
            }
            this.throwables.add(ex);
            this.actions.add(row);
            this.addresses.add(serverName != null ? serverName.toString() : "null");
        }

        public boolean hasErrors() {
            return !this.throwables.isEmpty();
        }

        private synchronized RetriesExhaustedWithDetailsException makeException() {
            return new RetriesExhaustedWithDetailsException(new ArrayList<Throwable>(this.throwables), new ArrayList<Row>(this.actions), new ArrayList<String>(this.addresses));
        }

        public synchronized void clear() {
            this.throwables.clear();
            this.actions.clear();
            this.addresses.clear();
        }

        public synchronized void merge(BatchErrors other) {
            this.throwables.addAll(other.throwables);
            this.actions.addAll(other.actions);
            this.addresses.addAll(other.addresses);
        }
    }

    private static class ReplicaResultState {
        int callCount;
        BatchErrors replicaErrors = null;

        public ReplicaResultState(int callCount) {
            this.callCount = callCount;
        }

        public String toString() {
            return "[call count " + this.callCount + "; errors " + this.replicaErrors + "]";
        }
    }

    public static interface AsyncRequestFuture {
        public boolean hasError();

        public RetriesExhaustedWithDetailsException getErrors();

        public List<? extends Row> getFailedOperations();

        public Object[] getResults() throws InterruptedIOException;

        public void waitUntilDone() throws InterruptedIOException;
    }
}

