/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.protobuf.Message;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigListener;
import org.apache.hadoop.hbase.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ReplicationPeerZKImpl
implements ReplicationPeer,
Abortable,
Closeable {
    private static final Log LOG = LogFactory.getLog(ReplicationPeerZKImpl.class);
    private ReplicationPeerConfig peerConfig;
    private final String id;
    private volatile ReplicationPeer.PeerState peerState;
    private volatile Map<String, List<String>> tableCFs = new HashMap<String, List<String>>();
    private final Configuration conf;
    private PeerStateTracker peerStateTracker;
    private TableCFsTracker tableCFsTracker;
    private PeerConfigTracker peerConfigTracker;

    public ReplicationPeerZKImpl(Configuration conf, String id, ReplicationPeerConfig peerConfig) throws ReplicationException {
        this.conf = conf;
        this.peerConfig = peerConfig;
        this.id = id;
    }

    public void startStateTracker(ZooKeeperWatcher zookeeper, String peerStateNode) throws KeeperException {
        ReplicationPeerZKImpl.ensurePeerEnabled(zookeeper, peerStateNode);
        this.peerStateTracker = new PeerStateTracker(peerStateNode, zookeeper, this);
        this.peerStateTracker.start();
        try {
            this.readPeerStateZnode();
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }

    private void readPeerStateZnode() throws DeserializationException {
        this.peerState = ReplicationPeerZKImpl.isStateEnabled(this.peerStateTracker.getData(false)) ? ReplicationPeer.PeerState.ENABLED : ReplicationPeer.PeerState.DISABLED;
    }

    public void startTableCFsTracker(ZooKeeperWatcher zookeeper, String tableCFsNode) throws KeeperException {
        this.tableCFsTracker = new TableCFsTracker(tableCFsNode, zookeeper, this);
        this.tableCFsTracker.start();
        this.readTableCFsZnode();
    }

    static Map<String, List<String>> parseTableCFsFromConfig(String tableCFsConfig) {
        String[] tables;
        if (tableCFsConfig == null || tableCFsConfig.trim().length() == 0) {
            return null;
        }
        HashMap tableCFsMap = null;
        for (String tab : tables = tableCFsConfig.split(";")) {
            if ((tab = tab.trim()).length() == 0) continue;
            String[] pair = tab.split(":");
            String tabName = pair[0].trim();
            if (pair.length > 2 || tabName.length() == 0) {
                LOG.error((Object)("ignore invalid tableCFs setting: " + tab));
                continue;
            }
            ArrayList<String> cfs = null;
            if (pair.length == 2) {
                String[] cfsList;
                for (String cf : cfsList = pair[1].split(",")) {
                    String cfName = cf.trim();
                    if (cfName.length() <= 0) continue;
                    if (cfs == null) {
                        cfs = new ArrayList<String>();
                    }
                    cfs.add(cfName);
                }
            }
            if (tableCFsMap == null) {
                tableCFsMap = new HashMap();
            }
            tableCFsMap.put(tabName, cfs);
        }
        return tableCFsMap;
    }

    public void startPeerConfigTracker(ZooKeeperWatcher zookeeper, String peerConfigNode) throws KeeperException {
        this.peerConfigTracker = new PeerConfigTracker(peerConfigNode, zookeeper, this);
        this.peerConfigTracker.start();
        this.readPeerConfig();
    }

    private void readTableCFsZnode() {
        String currentTableCFs = Bytes.toString((byte[])this.tableCFsTracker.getData(false));
        this.tableCFs = ReplicationPeerZKImpl.parseTableCFsFromConfig(currentTableCFs);
    }

    private ReplicationPeerConfig readPeerConfig() {
        try {
            byte[] data = this.peerConfigTracker.getData(false);
            if (data != null) {
                this.peerConfig = ReplicationSerDeHelper.parsePeerFrom(data);
            }
        }
        catch (DeserializationException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return this.peerConfig;
    }

    @Override
    public ReplicationPeer.PeerState getPeerState() {
        return this.peerState;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReplicationPeerConfig getPeerConfig() {
        return this.peerConfig;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public Map<String, List<String>> getTableCFs() {
        return this.tableCFs;
    }

    @Override
    public void trackPeerConfigChanges(ReplicationPeerConfigListener listener) {
        if (this.peerConfigTracker != null) {
            this.peerConfigTracker.setListener(listener);
        }
    }

    @Override
    public void abort(String why, Throwable e) {
        LOG.fatal((Object)("The ReplicationPeer corresponding to peer " + this.peerConfig + " was aborted for the following reason(s):" + why), e);
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public static boolean isStateEnabled(byte[] bytes) throws DeserializationException {
        ZooKeeperProtos.ReplicationState.State state = ReplicationPeerZKImpl.parseStateFrom(bytes);
        return ZooKeeperProtos.ReplicationState.State.ENABLED == state;
    }

    private static ZooKeeperProtos.ReplicationState.State parseStateFrom(byte[] bytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(bytes);
        int pblen = ProtobufUtil.lengthOfPBMagic();
        ZooKeeperProtos.ReplicationState.Builder builder = ZooKeeperProtos.ReplicationState.newBuilder();
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
            ZooKeeperProtos.ReplicationState state = builder.build();
            return state.getState();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    private static boolean ensurePeerEnabled(ZooKeeperWatcher zookeeper, String path) throws KeeperException.NodeExistsException, KeeperException {
        if (ZKUtil.checkExists(zookeeper, path) == -1) {
            ZKUtil.createNodeIfNotExistsAndWatch(zookeeper, path, ReplicationStateZKBase.ENABLED_ZNODE_BYTES);
            return true;
        }
        return false;
    }

    public class PeerConfigTracker
    extends ZooKeeperNodeTracker {
        private ReplicationPeerConfigListener listener;

        public PeerConfigTracker(String peerConfigNode, ZooKeeperWatcher watcher, Abortable abortable) {
            super(watcher, peerConfigNode, abortable);
        }

        public synchronized void setListener(ReplicationPeerConfigListener listener) {
            this.listener = listener;
        }

        @Override
        public synchronized void nodeCreated(String path) {
            if (path.equals(this.node)) {
                super.nodeCreated(path);
                ReplicationPeerConfig config = ReplicationPeerZKImpl.this.readPeerConfig();
                if (this.listener != null) {
                    this.listener.peerConfigUpdated(config);
                }
            }
        }

        @Override
        public synchronized void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                super.nodeDataChanged(path);
            }
        }
    }

    public class TableCFsTracker
    extends ZooKeeperNodeTracker {
        public TableCFsTracker(String tableCFsZNode, ZooKeeperWatcher watcher, Abortable abortable) {
            super(watcher, tableCFsZNode, abortable);
        }

        @Override
        public synchronized void nodeCreated(String path) {
            if (path.equals(this.node)) {
                super.nodeCreated(path);
                ReplicationPeerZKImpl.this.readTableCFsZnode();
            }
        }

        @Override
        public synchronized void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                super.nodeDataChanged(path);
            }
        }
    }

    public class PeerStateTracker
    extends ZooKeeperNodeTracker {
        public PeerStateTracker(String peerStateZNode, ZooKeeperWatcher watcher, Abortable abortable) {
            super(watcher, peerStateZNode, abortable);
        }

        @Override
        public synchronized void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                super.nodeDataChanged(path);
                try {
                    ReplicationPeerZKImpl.this.readPeerStateZnode();
                }
                catch (DeserializationException e) {
                    LOG.warn((Object)("Failed deserializing the content of " + path), (Throwable)e);
                }
            }
        }
    }
}

