/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.util.StringHelper;

@XmlRootElement(name="container")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ContainerInfo {
    protected String id;
    protected String state;
    protected int exitCode;
    protected String diagnostics;
    protected String user;
    protected long totalMemoryNeededMB;
    protected String containerLogsLink;
    protected String nodeId;
    @XmlTransient
    protected String containerLogsShortLink;
    @XmlTransient
    protected String exitStatus;

    public ContainerInfo() {
    }

    public ContainerInfo(Context nmContext, Container container) {
        this(nmContext, container, "", "");
    }

    public ContainerInfo(Context nmContext, Container container, String requestUri, String pathPrefix) {
        this.id = container.getContainerId().toString();
        this.nodeId = nmContext.getNodeId().toString();
        ContainerStatus containerData = container.cloneAndGetContainerStatus();
        this.exitCode = containerData.getExitStatus();
        this.exitStatus = this.exitCode == -1000 ? "N/A" : String.valueOf(this.exitCode);
        this.state = container.getContainerState().toString();
        this.diagnostics = containerData.getDiagnostics();
        if (this.diagnostics == null || this.diagnostics.isEmpty()) {
            this.diagnostics = "";
        }
        this.user = container.getUser();
        Resource res = container.getResource();
        if (res != null) {
            this.totalMemoryNeededMB = res.getMemory();
        }
        this.containerLogsShortLink = StringHelper.ujoin((String)"containerlogs", (String[])new String[]{this.id, container.getUser()});
        if (requestUri == null) {
            requestUri = "";
        }
        if (pathPrefix == null) {
            pathPrefix = "";
        }
        this.containerLogsLink = StringHelper.join((Object[])new Object[]{requestUri, pathPrefix, this.containerLogsShortLink});
    }

    public String getId() {
        return this.id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getState() {
        return this.state;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public String getUser() {
        return this.user;
    }

    public String getShortLogLink() {
        return this.containerLogsShortLink;
    }

    public String getLogLink() {
        return this.containerLogsLink;
    }

    public long getMemoryNeeded() {
        return this.totalMemoryNeededMB;
    }
}

