/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.adapter;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.executiongraph.failover.adapter.DefaultFailoverEdge;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverEdge;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverVertex;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

class DefaultFailoverVertex
implements FailoverVertex {
    private final ExecutionVertexID executionVertexID;
    private final String executionVertexName;
    private final List<DefaultFailoverEdge> inputEdges;
    private final List<DefaultFailoverEdge> outputEdges;

    DefaultFailoverVertex(ExecutionVertexID executionVertexID, String executionVertexName) {
        this.executionVertexID = (ExecutionVertexID)Preconditions.checkNotNull((Object)executionVertexID);
        this.executionVertexName = (String)Preconditions.checkNotNull((Object)executionVertexName);
        this.inputEdges = new ArrayList<DefaultFailoverEdge>();
        this.outputEdges = new ArrayList<DefaultFailoverEdge>();
    }

    @Override
    public ExecutionVertexID getExecutionVertexID() {
        return this.executionVertexID;
    }

    @Override
    public String getExecutionVertexName() {
        return this.executionVertexName;
    }

    @Override
    public Iterable<? extends FailoverEdge> getInputEdges() {
        return this.inputEdges;
    }

    @Override
    public Iterable<? extends FailoverEdge> getOutputEdges() {
        return this.outputEdges;
    }

    void addInputEdge(DefaultFailoverEdge edge) {
        this.inputEdges.add(edge);
    }

    void addOutputEdge(DefaultFailoverEdge edge) {
        this.outputEdges.add(edge);
    }
}

