/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.RequestHandler;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.util.Preconditions;

public abstract class AbstractJsonRequestHandler
implements RequestHandler {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    protected final Executor executor;

    protected AbstractJsonRequestHandler(Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    public CompletableFuture<FullHttpResponse> handleRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        CompletableFuture<String> resultFuture = this.handleJsonRequest(pathParams, queryParams, jobManagerGateway);
        return resultFuture.thenApplyAsync(result -> {
            byte[] bytes = result.getBytes(ENCODING);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])bytes));
            response.headers().set("Content-Type", (Object)("application/json; charset=" + ENCODING.name()));
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            return response;
        });
    }

    public abstract CompletableFuture<String> handleJsonRequest(Map<String, String> var1, Map<String, String> var2, JobManagerGateway var3);
}

