/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.decline.AlignmentLimitExceededException;
import org.apache.flink.runtime.checkpoint.decline.CheckpointDeclineOnCancellationBarrierException;
import org.apache.flink.runtime.checkpoint.decline.CheckpointDeclineSubsumedException;
import org.apache.flink.runtime.checkpoint.decline.CheckpointDeclineTaskNotCheckpointingException;
import org.apache.flink.runtime.checkpoint.decline.CheckpointDeclineTaskNotReadyException;
import org.apache.flink.runtime.checkpoint.decline.InputEndOfStreamException;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.checkpoint.AbstractCheckpointMessage;
import org.apache.flink.util.SerializedThrowable;

public class DeclineCheckpoint
extends AbstractCheckpointMessage
implements Serializable {
    private static final long serialVersionUID = 2094094662279578953L;
    private final Throwable reason;

    public DeclineCheckpoint(JobID job, ExecutionAttemptID taskExecutionId, long checkpointId) {
        this(job, taskExecutionId, checkpointId, null);
    }

    public DeclineCheckpoint(JobID job, ExecutionAttemptID taskExecutionId, long checkpointId, Throwable reason) {
        super(job, taskExecutionId, checkpointId);
        this.reason = reason == null || reason.getClass() == AlignmentLimitExceededException.class || reason.getClass() == CheckpointDeclineOnCancellationBarrierException.class || reason.getClass() == CheckpointDeclineSubsumedException.class || reason.getClass() == CheckpointDeclineTaskNotCheckpointingException.class || reason.getClass() == CheckpointDeclineTaskNotReadyException.class || reason.getClass() == InputEndOfStreamException.class ? reason : new SerializedThrowable(reason);
    }

    public Throwable getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        return String.format("Declined Checkpoint %d for (%s/%s): %s", new Object[]{this.getCheckpointId(), this.getJob(), this.getTaskExecutionId(), this.reason});
    }
}

