/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;

public class JobPlanHandler
extends AbstractExecutionGraphRequestHandler {
    private static final String JOB_PLAN_REST_PATH = "/jobs/:jobid/plan";

    public JobPlanHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public String[] getPaths() {
        return new String[]{JOB_PLAN_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionGraph graph, Map<String, String> params) {
        return CompletableFuture.completedFuture(graph.getJsonPlan());
    }

    public static class JobPlanJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            String path = JobPlanHandler.JOB_PLAN_REST_PATH.replace(":jobid", graph.getJobID().toString());
            String json = graph.getJsonPlan();
            return Collections.singletonList(new ArchivedJson(path, json));
        }
    }
}

