/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.call.AbstractServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.observer.ServerCallToObserverAdapter;

public class BiStreamServerCallListener
extends AbstractServerCallListener {
    private StreamObserver<Object> requestObserver;

    public BiStreamServerCallListener(RpcInvocation invocation, Invoker<?> invoker, ServerCallToObserverAdapter<Object> responseObserver) {
        super(invocation, invoker, responseObserver);
        invocation.setArguments(new Object[]{responseObserver});
        this.invoke();
    }

    @Override
    public void onReturn(Object value) {
        this.requestObserver = (StreamObserver)value;
    }

    @Override
    public void onMessage(Object message) {
        if (message instanceof Object[]) {
            message = ((Object[])message)[0];
        }
        this.requestObserver.onNext(message);
        if (this.responseObserver.isAutoRequestN()) {
            this.responseObserver.request(1);
        }
    }

    @Override
    public void onCancel(TriRpcStatus status) {
        this.responseObserver.onError((Throwable)((Object)status.asException()));
    }

    @Override
    public void onComplete() {
        this.requestObserver.onCompleted();
    }
}

