/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4.h2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;

public class NettyHttp2FrameCodec
extends ChannelDuplexHandler {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2Header http2Header = this.onHttp2HeadersFrame((Http2HeadersFrame)msg);
            super.channelRead(ctx, (Object)http2Header);
        } else if (msg instanceof Http2DataFrame) {
            Http2InputMessage http2Message = this.onHttp2DataFrame((Http2DataFrame)msg);
            super.channelRead(ctx, (Object)http2Message);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Http2Header) {
            Http2Header http2Header = (Http2Header)msg;
            Http2HeadersFrame http2HeadersFrame = this.encodeHttp2HeadersFrame(http2Header);
            super.write(ctx, (Object)http2HeadersFrame, promise);
        } else if (msg instanceof Http2OutputMessage) {
            Http2OutputMessage http2OutputMessage = (Http2OutputMessage)msg;
            Http2DataFrame http2DataFrame = this.encodeHttp2DataFrame(ctx, http2OutputMessage);
            super.write(ctx, (Object)http2DataFrame, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private Http2Header onHttp2HeadersFrame(Http2HeadersFrame headersFrame) {
        Http2Headers headers = headersFrame.headers();
        boolean endStream = headersFrame.isEndStream();
        HttpHeaders head = new HttpHeaders();
        for (Map.Entry header : headers) {
            head.set(((CharSequence)header.getKey()).toString(), ((CharSequence)header.getValue()).toString());
        }
        return new Http2MetadataFrame(headersFrame.stream().id(), head, endStream);
    }

    private Http2InputMessage onHttp2DataFrame(Http2DataFrame dataFrame) {
        ByteBuf content = dataFrame.content();
        Http2InputMessageFrame message = new Http2InputMessageFrame((InputStream)new ByteBufInputStream(content, true), dataFrame.isEndStream());
        message.setId(dataFrame.stream().id());
        return message;
    }

    private Http2HeadersFrame encodeHttp2HeadersFrame(Http2Header http2Header) {
        HttpHeaders headers = http2Header.headers();
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            List<String> value = entry.getValue();
            http2Headers.set((Object)name, value);
        }
        return new DefaultHttp2HeadersFrame((Http2Headers)http2Headers, http2Header.isEndStream());
    }

    private Http2DataFrame encodeHttp2DataFrame(ChannelHandlerContext ctx, Http2OutputMessage outputMessage) throws IOException {
        OutputStream body = outputMessage.getBody();
        if (body == null) {
            return new DefaultHttp2DataFrame(outputMessage.isEndStream());
        }
        if (body instanceof ByteBufOutputStream) {
            ByteBuf buffer = ((ByteBufOutputStream)body).buffer();
            return new DefaultHttp2DataFrame(buffer, outputMessage.isEndStream());
        }
        throw new IllegalArgumentException("Http2OutputMessage body must be ByteBufOutputStream");
    }
}

