/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;

public class HttpHeaders
implements Map<String, List<String>>,
Serializable,
Cloneable {
    private final LinkedHashMap<String, List<String>> targetMap = new LinkedHashMap();
    private final HashMap<String, String> caseInsensitiveKeys = new HashMap();
    private final Locale locale = Locale.US;
    private volatile transient Set<String> keySet;
    private volatile transient Collection<List<String>> values;
    private volatile transient Set<Map.Entry<String, List<String>>> entrySet;

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.caseInsensitiveKeys.containsKey(this.convertKey((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    @Override
    public List<String> get(Object key) {
        String caseInsensitiveKey;
        if (key instanceof String && (caseInsensitiveKey = this.caseInsensitiveKeys.get(this.convertKey((String)key))) != null) {
            return this.targetMap.get(caseInsensitiveKey);
        }
        return null;
    }

    public String getFirst(String name) {
        Object values = this.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    public void set(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.put(name, (List<String>)values);
    }

    @Override
    public List<String> getOrDefault(Object key, List<String> defaultValue) {
        String caseInsensitiveKey;
        if (key instanceof String && (caseInsensitiveKey = this.caseInsensitiveKeys.get(this.convertKey((String)key))) != null) {
            return this.targetMap.get(caseInsensitiveKey);
        }
        return defaultValue;
    }

    @Override
    public List<String> put(String key, List<String> value) {
        String oldKey = this.caseInsensitiveKeys.put(this.convertKey(key), key);
        List<String> oldKeyValue = null;
        if (oldKey != null && !oldKey.equals(key)) {
            oldKeyValue = (List<String>)this.targetMap.remove(oldKey);
        }
        List<String> oldValue = this.targetMap.put(key, value);
        return oldKeyValue != null ? oldKeyValue : oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        if (map.isEmpty()) {
            return;
        }
        map.forEach(this::put);
    }

    @Override
    public List<String> putIfAbsent(String key, List<String> value) {
        String oldKey = this.caseInsensitiveKeys.putIfAbsent(this.convertKey(key), key);
        if (oldKey != null) {
            List<String> oldKeyValue = this.targetMap.get(oldKey);
            if (oldKeyValue != null) {
                return oldKeyValue;
            }
            key = oldKey;
        }
        return this.targetMap.putIfAbsent(key, value);
    }

    @Override
    public List<String> computeIfAbsent(String key, Function<? super String, ? extends List<String>> mappingFunction) {
        String oldKey = this.caseInsensitiveKeys.putIfAbsent(this.convertKey(key), key);
        if (oldKey != null) {
            List<String> oldKeyValue = this.targetMap.get(oldKey);
            if (oldKeyValue != null) {
                return oldKeyValue;
            }
            key = oldKey;
        }
        return this.targetMap.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public List<String> remove(Object key) {
        String caseInsensitiveKey;
        if (key instanceof String && (caseInsensitiveKey = this.removeCaseInsensitiveKey((String)key)) != null) {
            return (List)this.targetMap.remove(caseInsensitiveKey);
        }
        return null;
    }

    @Override
    public void clear() {
        this.caseInsensitiveKeys.clear();
        this.targetMap.clear();
    }

    @Override
    public Set<String> keySet() {
        KeySet keySet = this.keySet;
        if (keySet == null) {
            this.keySet = keySet = new KeySet(this.targetMap.keySet());
        }
        return keySet;
    }

    @Override
    public Collection<List<String>> values() {
        Values values = this.values;
        if (values == null) {
            this.values = values = new Values(this.targetMap.values());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet(this.targetMap.entrySet());
        }
        return entrySet;
    }

    public Map<String, String> toSingleValueMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.targetMap.size());
        for (String key : this.keySet()) {
            result.put(key, this.getFirst(key));
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || this.targetMap.equals(other);
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String convertKey(String key) {
        return key.toLowerCase(this.getLocale());
    }

    protected boolean removeEldestEntry(Map.Entry<String, List<String>> eldest) {
        return false;
    }

    private String removeCaseInsensitiveKey(String key) {
        return this.caseInsensitiveKeys.remove(this.convertKey(key));
    }

    private class KeySet
    extends AbstractSet<String> {
        private final Set<String> delegate;

        KeySet(Set<String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<String> iterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean remove(Object o) {
            return HttpHeaders.this.remove(o) != null;
        }

        @Override
        public void clear() {
            HttpHeaders.this.clear();
        }

        @Override
        public Spliterator<String> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public void forEach(Consumer<? super String> action) {
            this.delegate.forEach(action);
        }
    }

    private class Values
    extends AbstractCollection<List<String>> {
        private final Collection<List<String>> delegate;

        Values(Collection<List<String>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<List<String>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void clear() {
            HttpHeaders.this.clear();
        }

        @Override
        public Spliterator<List<String>> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public void forEach(Consumer<? super List<String>> action) {
            this.delegate.forEach(action);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, List<String>>> {
        private final Set<Map.Entry<String, List<String>>> delegate;

        public EntrySet(Set<Map.Entry<String, List<String>>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<Map.Entry<String, List<String>>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (this.delegate.remove(o)) {
                HttpHeaders.this.removeCaseInsensitiveKey((String)((Map.Entry)o).getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.delegate.clear();
            HttpHeaders.this.caseInsensitiveKeys.clear();
        }

        @Override
        public Spliterator<Map.Entry<String, List<String>>> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<String, List<String>>> action) {
            this.delegate.forEach(action);
        }
    }

    private class EntrySetIterator
    extends EntryIterator<Map.Entry<String, List<String>>> {
        private EntrySetIterator() {
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return this.nextEntry();
        }
    }

    private class ValuesIterator
    extends EntryIterator<List<String>> {
        private ValuesIterator() {
        }

        @Override
        public List<String> next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeySetIterator
    extends EntryIterator<String> {
        private KeySetIterator() {
        }

        @Override
        public String next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class EntryIterator<T>
    implements Iterator<T> {
        private final Iterator<Map.Entry<String, List<String>>> delegate;
        private Map.Entry<String, List<String>> last;

        public EntryIterator() {
            this.delegate = HttpHeaders.this.targetMap.entrySet().iterator();
        }

        protected Map.Entry<String, List<String>> nextEntry() {
            Map.Entry<String, List<String>> entry = this.delegate.next();
            this.last = entry;
            return entry;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            this.delegate.remove();
            if (this.last != null) {
                HttpHeaders.this.removeCaseInsensitiveKey(this.last.getKey());
                this.last = null;
            }
        }
    }
}

