/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Client;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.remoting.exchange.support.header.AbstractTimerTask;
import org.apache.dubbo.remoting.exchange.support.header.HeaderExchangeChannel;
import org.apache.dubbo.remoting.exchange.support.header.HeartbeatTimerTask;
import org.apache.dubbo.remoting.exchange.support.header.ReconnectTimerTask;
import org.apache.dubbo.remoting.utils.UrlUtils;

public class HeaderExchangeClient
implements ExchangeClient {
    private final Client client;
    private final ExchangeChannel channel;
    private static final HashedWheelTimer IDLE_CHECK_TIMER = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("dubbo-client-idleCheck", true), 1L, TimeUnit.SECONDS, 128);
    private HeartbeatTimerTask heartBeatTimerTask;
    private ReconnectTimerTask reconnectTimerTask;

    public HeaderExchangeClient(Client client, boolean startTimer) {
        Assert.notNull((Object)client, (String)"Client can't be null");
        this.client = client;
        this.channel = new HeaderExchangeChannel(client);
        if (startTimer) {
            URL url = client.getUrl();
            this.startReconnectTask(url);
            this.startHeartBeatTask(url);
        }
    }

    @Override
    public CompletableFuture<Object> request(Object request) throws RemotingException {
        return this.channel.request(request);
    }

    @Override
    public URL getUrl() {
        return this.channel.getUrl();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    @Override
    public CompletableFuture<Object> request(Object request, int timeout) throws RemotingException {
        return this.channel.request(request, timeout);
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this.channel.getChannelHandler();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public ExchangeHandler getExchangeHandler() {
        return this.channel.getExchangeHandler();
    }

    @Override
    public void send(Object message) throws RemotingException {
        this.channel.send(message);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        this.channel.send(message, sent);
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    public void close() {
        this.doClose();
        this.channel.close();
    }

    @Override
    public void close(int timeout) {
        this.startClose();
        this.doClose();
        this.channel.close(timeout);
    }

    @Override
    public void startClose() {
        this.channel.startClose();
    }

    public void reset(URL url) {
        this.client.reset(url);
    }

    @Override
    @Deprecated
    public void reset(Parameters parameters) {
        this.reset(this.getUrl().addParameters(parameters.getParameters()));
    }

    @Override
    public void reconnect() throws RemotingException {
        this.client.reconnect();
    }

    @Override
    public Object getAttribute(String key) {
        return this.channel.getAttribute(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.channel.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.channel.removeAttribute(key);
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.channel.hasAttribute(key);
    }

    private void startHeartBeatTask(URL url) {
        if (!this.client.canHandleIdle()) {
            AbstractTimerTask.ChannelProvider cp = () -> Collections.singletonList(this);
            int heartbeat = UrlUtils.getHeartbeat(url);
            long heartbeatTick = this.calculateLeastDuration(heartbeat);
            this.heartBeatTimerTask = new HeartbeatTimerTask(cp, heartbeatTick, heartbeat);
            IDLE_CHECK_TIMER.newTimeout((TimerTask)this.heartBeatTimerTask, heartbeatTick, TimeUnit.MILLISECONDS);
        }
    }

    private void startReconnectTask(URL url) {
        if (this.shouldReconnect(url)) {
            AbstractTimerTask.ChannelProvider cp = () -> Collections.singletonList(this);
            int idleTimeout = UrlUtils.getIdleTimeout(url);
            long heartbeatTimeoutTick = this.calculateLeastDuration(idleTimeout);
            this.reconnectTimerTask = new ReconnectTimerTask(cp, heartbeatTimeoutTick, idleTimeout);
            IDLE_CHECK_TIMER.newTimeout((TimerTask)this.reconnectTimerTask, heartbeatTimeoutTick, TimeUnit.MILLISECONDS);
        }
    }

    private void doClose() {
        if (this.heartBeatTimerTask != null) {
            this.heartBeatTimerTask.cancel();
        }
        if (this.reconnectTimerTask != null) {
            this.reconnectTimerTask.cancel();
        }
    }

    private long calculateLeastDuration(int time) {
        if (time / 3 <= 0) {
            return 1000L;
        }
        return time / 3;
    }

    private boolean shouldReconnect(URL url) {
        return url.getParameter("reconnect", true);
    }

    public String toString() {
        return "HeaderExchangeClient [channel=" + this.channel + "]";
    }
}

