/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model.container;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.MetricsKeyWrapper;

public class LongContainer<N extends Number>
extends ConcurrentHashMap<String, N> {
    private final transient MetricsKeyWrapper metricsKeyWrapper;
    private final transient Function<String, N> initFunc;
    private final transient BiConsumer<Long, N> consumerFunc;
    private transient Function<String, Long> valueSupplier;

    public LongContainer(MetricsKeyWrapper metricsKeyWrapper, Supplier<N> initFunc, BiConsumer<Long, N> consumerFunc) {
        this.metricsKeyWrapper = metricsKeyWrapper;
        this.initFunc = s -> (Number)initFunc.get();
        this.consumerFunc = consumerFunc;
        this.valueSupplier = k -> ((Number)this.get(k)).longValue();
    }

    public boolean specifyType(String type) {
        return type.equals(this.getMetricsKeyWrapper().getType());
    }

    public MetricsKeyWrapper getMetricsKeyWrapper() {
        return this.metricsKeyWrapper;
    }

    public boolean isKeyWrapper(MetricsKey metricsKey, String registryOpType) {
        return this.metricsKeyWrapper.isKey(metricsKey, registryOpType);
    }

    public Function<String, N> getInitFunc() {
        return this.initFunc;
    }

    public BiConsumer<Long, N> getConsumerFunc() {
        return this.consumerFunc;
    }

    public Function<String, Long> getValueSupplier() {
        return this.valueSupplier;
    }

    public void setValueSupplier(Function<String, Long> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    @Override
    public String toString() {
        return "LongContainer{metricsKeyWrapper=" + this.metricsKeyWrapper + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LongContainer that = (LongContainer)o;
        return this.metricsKeyWrapper.equals(that.metricsKeyWrapper);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.metricsKeyWrapper.hashCode();
        return result;
    }
}

