/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;

public class LeveledCompactionTask
extends CompactionTask {
    private final int sstableSizeInMB;

    public LeveledCompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore, int sstableSizeInMB) {
        super(cfs, sstables, gcBefore);
        this.sstableSizeInMB = sstableSizeInMB;
    }

    @Override
    protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer) {
        return writer.getOnDiskFilePointer() > (long)this.sstableSizeInMB * 1024L * 1024L;
    }

    @Override
    protected boolean partialCompactionsAcceptable() {
        return false;
    }
}

