/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;

class SimpleSliceReader
extends AbstractIterator<OnDiskAtom>
implements OnDiskAtomIterator {
    private final SSTableReader sstable;
    private final FileDataInput file;
    private final boolean needsClosing;
    private final ByteBuffer finishColumn;
    private final AbstractType<?> comparator;
    private final ColumnFamily emptyColumnFamily;
    private final int columns;
    private int i;
    private FileMark mark;
    private final OnDiskAtom.Serializer atomSerializer;

    public SimpleSliceReader(SSTableReader sstable, RowIndexEntry indexEntry, FileDataInput input, ByteBuffer finishColumn) {
        Tracing.trace("Seeking to partition beginning in data file");
        this.sstable = sstable;
        this.finishColumn = finishColumn;
        this.comparator = sstable.metadata.comparator;
        try {
            if (input == null) {
                this.file = sstable.getFileDataInput(indexEntry.position);
                this.needsClosing = true;
            } else {
                this.file = input;
                input.seek(indexEntry.position);
                this.needsClosing = false;
            }
            ByteBufferUtil.skipShortLength(this.file);
            SSTableReader.readRowSize(this.file, sstable.descriptor);
            Descriptor.Version version = sstable.descriptor.version;
            if (!version.hasPromotedIndexes) {
                IndexHelper.skipBloomFilter(this.file);
                IndexHelper.skipIndex(this.file);
            }
            this.emptyColumnFamily = ColumnFamily.create(sstable.metadata);
            this.emptyColumnFamily.delete(DeletionInfo.serializer().deserializeFromSSTable(this.file, version));
            this.atomSerializer = this.emptyColumnFamily.getOnDiskSerializer();
            this.columns = this.file.readInt();
            this.mark = this.file.mark();
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, sstable.getFilename());
        }
    }

    protected OnDiskAtom computeNext() {
        OnDiskAtom column;
        if (this.i++ >= this.columns) {
            return (OnDiskAtom)this.endOfData();
        }
        try {
            this.file.reset(this.mark);
            column = this.atomSerializer.deserializeFromSSTable(this.file, this.sstable.descriptor.version);
        }
        catch (IOException e) {
            throw new CorruptSSTableException((Exception)e, this.file.getPath());
        }
        if (this.finishColumn.remaining() > 0 && this.comparator.compare(column.name(), this.finishColumn) > 0) {
            return (OnDiskAtom)this.endOfData();
        }
        this.mark = this.file.mark();
        return column;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.emptyColumnFamily;
    }

    @Override
    public void close() throws IOException {
        if (this.needsClosing) {
            this.file.close();
        }
    }

    @Override
    public DecoratedKey getKey() {
        throw new UnsupportedOperationException();
    }
}

