/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.cassandra.db.AbstractThreadUnsafeSortedColumns;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.Allocator;

public class ThreadSafeSortedColumns
extends AbstractThreadUnsafeSortedColumns
implements ISortedColumns {
    private final ConcurrentSkipListMap<ByteBuffer, IColumn> map;
    public static final ISortedColumns.Factory factory = new ISortedColumns.Factory(){

        @Override
        public ISortedColumns create(AbstractType<?> comparator, boolean insertReversed) {
            return new ThreadSafeSortedColumns(comparator);
        }

        @Override
        public ISortedColumns fromSorted(SortedMap<ByteBuffer, IColumn> sortedMap, boolean insertReversed) {
            return new ThreadSafeSortedColumns(sortedMap);
        }
    };

    public static ISortedColumns.Factory factory() {
        return factory;
    }

    @Override
    public AbstractType<?> getComparator() {
        return (AbstractType)this.map.comparator();
    }

    private ThreadSafeSortedColumns(AbstractType<?> comparator) {
        this.map = new ConcurrentSkipListMap(comparator);
    }

    private ThreadSafeSortedColumns(SortedMap<ByteBuffer, IColumn> columns) {
        this.map = new ConcurrentSkipListMap<ByteBuffer, IColumn>(columns);
    }

    @Override
    public ISortedColumns.Factory getFactory() {
        return ThreadSafeSortedColumns.factory();
    }

    @Override
    public ISortedColumns cloneMe() {
        return new ThreadSafeSortedColumns(this.map);
    }

    @Override
    public boolean isInsertReversed() {
        return false;
    }

    @Override
    public void addColumn(IColumn column, Allocator allocator) {
        this.addColumnInternal(column, allocator);
    }

    private long addColumnInternal(IColumn column, Allocator allocator) {
        IColumn reconciledColumn;
        IColumn oldColumn;
        ByteBuffer name = column.name();
        do {
            if ((oldColumn = this.map.putIfAbsent(name, column)) == null) {
                return column.dataSize();
            }
            if (!(oldColumn instanceof SuperColumn)) continue;
            assert (column instanceof SuperColumn);
            long previousSize = oldColumn.dataSize();
            ((SuperColumn)oldColumn).putColumn((SuperColumn)column, allocator);
            return (long)oldColumn.dataSize() - previousSize;
        } while (!this.map.replace(name, oldColumn, reconciledColumn = column.reconcile(oldColumn, allocator)));
        return reconciledColumn.dataSize() - oldColumn.dataSize();
    }

    @Override
    public void addAll(ISortedColumns cm, Allocator allocator, Function<IColumn, IColumn> transformation) {
        this.addAllWithSizeDelta(cm, allocator, transformation, null);
    }

    @Override
    public long addAllWithSizeDelta(ISortedColumns cm, Allocator allocator, Function<IColumn, IColumn> transformation, SecondaryIndexManager.Updater indexer) {
        this.delete(cm.getDeletionInfo());
        long sizeDelta = 0L;
        for (IColumn column : cm.getSortedColumns()) {
            sizeDelta += this.addColumnInternal((IColumn)transformation.apply((Object)column), allocator);
        }
        return sizeDelta;
    }

    @Override
    public boolean replace(IColumn oldColumn, IColumn newColumn) {
        if (!oldColumn.name().equals(newColumn.name())) {
            throw new IllegalArgumentException();
        }
        return this.map.replace(oldColumn.name(), oldColumn, newColumn);
    }

    @Override
    public IColumn getColumn(ByteBuffer name) {
        return this.map.get(name);
    }

    @Override
    public void removeColumn(ByteBuffer name) {
        this.map.remove(name);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<IColumn> getSortedColumns() {
        return this.map.values();
    }

    @Override
    public Collection<IColumn> getReverseSortedColumns() {
        return this.map.descendingMap().values();
    }

    @Override
    public SortedSet<ByteBuffer> getColumnNames() {
        return this.map.navigableKeySet();
    }

    @Override
    public Iterator<IColumn> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Iterator<IColumn> iterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableMapIterator(this.map, slices);
    }

    @Override
    public Iterator<IColumn> reverseIterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableMapIterator(this.map.descendingMap(), slices);
    }
}

