/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ST {
    public static final String VERSION = "@version@";
    public static final String UNKNOWN_NAME = "anonymous";
    public static final Object EMPTY_ATTR = new Object();
    public static STNoSuchPropertyException cachedNoSuchPropException;
    public CompiledST impl;
    protected Object[] locals;
    public ST enclosingInstance;
    public STGroup groupThatCreatedThisInstance;
    static /* synthetic */ Class class$org$stringtemplate$v4$ST$RegionType;
    static /* synthetic */ Class class$org$stringtemplate$v4$ST$AttributeList;

    public ST() {
    }

    public ST(String template) {
        this(STGroup.defaultGroup, template);
    }

    public ST(String template, char delimiterStartChar, char delimiterStopChar) {
        this(new STGroup(delimiterStartChar, delimiterStopChar), template);
    }

    public ST(STGroup group, String template) {
        this.groupThatCreatedThisInstance = group;
        this.impl = this.groupThatCreatedThisInstance.compile(group.getFileName(), null, null, template, null);
        this.impl.hasFormalArgs = false;
        this.impl.name = UNKNOWN_NAME;
        this.impl.defineImplicitlyDefinedTemplates(this.groupThatCreatedThisInstance);
    }

    public ST(ST proto) {
        this.impl = proto.impl;
        if (proto.locals != null) {
            this.locals = Arrays.copyOf(proto.locals, proto.locals.length);
        }
        this.enclosingInstance = proto.enclosingInstance;
        this.groupThatCreatedThisInstance = proto.groupThatCreatedThisInstance;
    }

    public synchronized ST add(String name, Object value) {
        AttributeList<Object> multi;
        Object curvalue;
        if (name == null) {
            return this;
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in attribute names");
        }
        FormalArgument arg = null;
        if (this.impl.hasFormalArgs) {
            if (this.impl.formalArguments != null) {
                arg = this.impl.formalArguments.get(name);
            }
            if (arg == null) {
                throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
            }
        } else {
            if (this.impl.formalArguments != null) {
                arg = this.impl.formalArguments.get(name);
            }
            if (arg == null) {
                arg = new FormalArgument(name);
                this.impl.addArg(arg);
                this.locals = this.locals == null ? new Object[1] : Arrays.copyOf(this.locals, this.impl.formalArguments.size());
                this.locals[arg.index] = EMPTY_ATTR;
            }
        }
        if (value instanceof ST) {
            ((ST)value).enclosingInstance = this;
        }
        if ((curvalue = this.locals[arg.index]) == EMPTY_ATTR) {
            this.locals[arg.index] = value;
            return this;
        }
        this.locals[arg.index] = multi = ST.convertToAttributeList(curvalue);
        if (value instanceof List) {
            multi.addAll((List)value);
        } else if (value != null && value.getClass().isArray()) {
            multi.addAll(Arrays.asList(value));
        } else {
            multi.add(value);
        }
        return this;
    }

    public void remove(String name) {
        if (this.impl.formalArguments == null) {
            if (this.impl.hasFormalArgs) {
                throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
            }
            return;
        }
        FormalArgument arg = this.impl.formalArguments.get(name);
        if (arg == null) {
            throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
        }
        this.locals[arg.index] = EMPTY_ATTR;
    }

    protected void rawSetAttribute(String name, Object value) {
        if (this.impl.formalArguments == null) {
            throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
        }
        FormalArgument arg = this.impl.formalArguments.get(name);
        if (arg == null) {
            throw new IllegalArgumentException(new StringBuffer().append("no such attribute: ").append(name).toString());
        }
        this.locals[arg.index] = value;
    }

    public Object getAttribute(String name) {
        ST p = this;
        while (p != null) {
            FormalArgument localArg = null;
            if (p.impl.formalArguments != null) {
                localArg = p.impl.formalArguments.get(name);
            }
            if (localArg != null) {
                Object o = p.locals[localArg.index];
                if (o == EMPTY_ATTR) {
                    o = null;
                }
                return o;
            }
            p = p.enclosingInstance;
        }
        if (this.impl.nativeGroup.isDictionary(name)) {
            return this.impl.nativeGroup.rawGetDictionary(name);
        }
        if (cachedNoSuchPropException == null) {
            cachedNoSuchPropException = new STNoSuchPropertyException();
        }
        ST.cachedNoSuchPropException.propertyName = name;
        throw cachedNoSuchPropException;
    }

    public Map<String, Object> getAttributes() {
        if (this.impl.formalArguments == null) {
            return null;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (FormalArgument a : this.impl.formalArguments.values()) {
            Object o = this.locals[a.index];
            if (o == EMPTY_ATTR) {
                o = null;
            }
            attributes.put(a.name, o);
        }
        return attributes;
    }

    protected static AttributeList<Object> convertToAttributeList(Object curvalue) {
        AttributeList multi;
        if (curvalue == null) {
            multi = new AttributeList();
            multi.add(curvalue);
        } else if (curvalue.getClass() == (class$org$stringtemplate$v4$ST$AttributeList == null ? (class$org$stringtemplate$v4$ST$AttributeList = ST.class$("org.stringtemplate.v4.ST$AttributeList")) : class$org$stringtemplate$v4$ST$AttributeList)) {
            multi = (AttributeList)curvalue;
        } else if (curvalue instanceof List) {
            List listAttr = (List)curvalue;
            multi = new AttributeList(listAttr.size());
            multi.addAll(listAttr);
        } else if (curvalue.getClass().isArray()) {
            Object[] a = (Object[])curvalue;
            multi = new AttributeList(a.length);
            multi.addAll(Arrays.asList(a));
        } else {
            multi = new AttributeList();
            multi.add(curvalue);
        }
        return multi;
    }

    public String getEnclosingInstanceStackString() {
        List<ST> templates = this.getEnclosingInstanceStack(true);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (ST st : templates) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(st.getName());
            ++i;
        }
        return buf.toString();
    }

    public List<ST> getEnclosingInstanceStack(boolean topdown) {
        LinkedList<ST> stack = new LinkedList<ST>();
        ST p = this;
        while (p != null) {
            if (topdown) {
                stack.add(0, p);
            } else {
                stack.add(p);
            }
            p = p.enclosingInstance;
        }
        return stack;
    }

    public String getName() {
        return this.impl.name;
    }

    public boolean isAnonSubtemplate() {
        return this.impl.isAnonSubtemplate;
    }

    public int write(STWriter out) throws IOException {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, this.impl.nativeGroup.errMgr);
        interp.setDefaultArguments(out, this);
        return interp.exec(out, this);
    }

    public int write(STWriter out, Locale locale) {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, this.impl.nativeGroup.errMgr);
        interp.setDefaultArguments(out, this);
        return interp.exec(out, this);
    }

    public int write(STWriter out, STErrorListener listener) {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, new ErrorManager(listener));
        interp.setDefaultArguments(out, this);
        return interp.exec(out, this);
    }

    public int write(STWriter out, Locale locale, STErrorListener listener) {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, new ErrorManager(listener));
        interp.setDefaultArguments(out, this);
        return interp.exec(out, this);
    }

    public int write(File outputFile, STErrorListener listener) throws IOException {
        return this.write(outputFile, listener, "UTF-8", Locale.getDefault(), -1);
    }

    public int write(File outputFile, STErrorListener listener, String encoding) throws IOException {
        return this.write(outputFile, listener, encoding, Locale.getDefault(), -1);
    }

    public int write(File outputFile, STErrorListener listener, String encoding, int lineWidth) throws IOException {
        return this.write(outputFile, listener, encoding, Locale.getDefault(), lineWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(File outputFile, STErrorListener listener, String encoding, Locale locale, int lineWidth) throws IOException {
        Writer bw = null;
        try {
            FileOutputStream fos = new FileOutputStream(outputFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
            bw = new BufferedWriter(osw);
            AutoIndentWriter w = new AutoIndentWriter(bw);
            w.setLineWidth(lineWidth);
            int n = this.write(w, locale, listener);
            bw.close();
            bw = null;
            int n2 = n;
            return n2;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }

    public String render() {
        return this.render(Locale.getDefault());
    }

    public String render(int lineWidth) {
        return this.render(Locale.getDefault(), lineWidth);
    }

    public String render(Locale locale) {
        return this.render(locale, -1);
    }

    public String render(Locale locale, int lineWidth) {
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter(out);
        wr.setLineWidth(lineWidth);
        this.write((STWriter)wr, locale);
        return out.toString();
    }

    public String toString() {
        if (this.impl == null) {
            return "bad-template()";
        }
        return new StringBuffer().append(this.impl.name).append("()").toString();
    }

    public static String format(String template, Object[] attributes) {
        return ST.format(-1, template, attributes);
    }

    public static String format(int lineWidth, String template, Object[] attributes) {
        template = template.replaceAll("%([0-9]+)", "arg$1");
        System.out.println(template);
        ST st = new ST(template);
        int i = 1;
        for (Object a : attributes) {
            st.add(new StringBuffer().append("arg").append(i).toString(), a);
            ++i;
        }
        return st.render(lineWidth);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AttributeList<T>
    extends ArrayList<T> {
        public AttributeList(int size) {
            super(size);
        }

        public AttributeList() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RegionType
    extends Enum<RegionType> {
        public static final RegionType IMPLICIT = new RegionType("IMPLICIT", 0);
        public static final RegionType EMBEDDED = new RegionType("EMBEDDED", 1);
        public static final RegionType EXPLICIT = new RegionType("EXPLICIT", 2);
        private static final /* synthetic */ RegionType[] $VALUES;

        public static RegionType[] values() {
            return (RegionType[])$VALUES.clone();
        }

        public static RegionType valueOf(String name) {
            return (RegionType)((Object)Enum.valueOf(class$org$stringtemplate$v4$ST$RegionType == null ? (class$org$stringtemplate$v4$ST$RegionType = ST.class$("org.stringtemplate.v4.ST$RegionType")) : class$org$stringtemplate$v4$ST$RegionType, name));
        }

        private RegionType() {
        }

        static {
            $VALUES = new RegionType[]{IMPLICIT, EMBEDDED, EXPLICIT};
        }
    }
}

