/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.protocol.binary.SingleKeyOperationImpl;

public class GetAndTouchOperationImpl
extends SingleKeyOperationImpl
implements GetAndTouchOperation {
    static final byte GAT_CMD = 29;
    static final int EXTRA_HDR_LEN = 4;
    private final int exp;

    public GetAndTouchOperationImpl(String k, int e, GetAndTouchOperation.Callback cb) {
        super((byte)29, GetAndTouchOperationImpl.generateOpaque(), k, cb);
        this.exp = e;
    }

    @Override
    public void initialize() {
        this.prepareBuffer(this.key, 0L, EMPTY_BYTES, this.exp);
    }

    @Override
    protected void decodePayload(byte[] pl) {
        int flags = GetAndTouchOperationImpl.decodeInt(pl, 0);
        byte[] data = new byte[pl.length - 4];
        System.arraycopy(pl, 4, data, 0, pl.length - 4);
        GetAndTouchOperation.Callback gcb = (GetAndTouchOperation.Callback)this.getCallback();
        gcb.gotData(this.key, flags, this.responseCas, data);
        this.getCallback().receivedStatus(STATUS_OK);
    }

    @Override
    public String toString() {
        return super.toString() + " Exp: " + this.exp;
    }

    @Override
    public int getExpiration() {
        return this.exp;
    }
}

