/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;

public class ConsecutiveAppendsShouldReuseRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTBlockStatement node, Object data) {
        String nextVariable;
        ASTBlockStatement nextSibling;
        String variable = this.getVariableAppended(node);
        if (variable != null && (nextSibling = this.getNextBlockStatementSibling((Node)node)) != null && (nextVariable = this.getVariableAppended(nextSibling)) != null && nextVariable.equals(variable)) {
            this.addViolation(data, (Node)node);
        }
        return super.visit(node, data);
    }

    private ASTBlockStatement getNextBlockStatementSibling(Node node) {
        Node nextSibling;
        Node parent = node.jjtGetParent();
        int childIndex = -1;
        for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
            if (parent.jjtGetChild(i) != node) continue;
            childIndex = i;
            break;
        }
        if (childIndex + 1 < parent.jjtGetNumChildren() && (nextSibling = parent.jjtGetChild(childIndex + 1)) instanceof ASTBlockStatement) {
            return (ASTBlockStatement)nextSibling;
        }
        return null;
    }

    private String getVariableAppended(ASTBlockStatement node) {
        if (this.isFirstChild((Node)node, ASTStatement.class)) {
            ASTStatement statement = (ASTStatement)node.jjtGetChild(0);
            if (this.isFirstChild((Node)statement, ASTStatementExpression.class)) {
                ASTStatementExpression stmtExp = (ASTStatementExpression)statement.jjtGetChild(0);
                if (stmtExp.jjtGetNumChildren() == 1) {
                    String variable;
                    String image;
                    ASTName name;
                    ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)stmtExp.getFirstDescendantOfType(ASTPrimaryPrefix.class);
                    if (primaryPrefix != null && (name = (ASTName)primaryPrefix.getFirstChildOfType(ASTName.class)) != null && (image = name.getImage()).endsWith(".append") && this.isAStringBuilderBuffer(primaryPrefix, variable = image.substring(0, image.indexOf(46)))) {
                        return variable;
                    }
                } else {
                    String variable;
                    ASTName astName;
                    ASTPrimaryExpression pExp;
                    String name;
                    ASTPrimarySuffix primarySuffix;
                    ASTExpression exp = (ASTExpression)stmtExp.getFirstDescendantOfType(ASTExpression.class);
                    if (this.isFirstChild(exp, ASTPrimaryExpression.class) && (primarySuffix = (ASTPrimarySuffix)((ASTPrimaryExpression)exp.jjtGetChild(0)).getFirstDescendantOfType(ASTPrimarySuffix.class)) != null && "append".equals(name = primarySuffix.getImage()) && (pExp = (ASTPrimaryExpression)stmtExp.getFirstDescendantOfType(ASTPrimaryExpression.class)) != null && (astName = (ASTName)stmtExp.getFirstDescendantOfType(ASTName.class)) != null && this.isAStringBuilderBuffer(primarySuffix, variable = astName.getImage())) {
                        return variable;
                    }
                }
            }
        } else if (this.isFirstChild((Node)node, ASTLocalVariableDeclaration.class)) {
            String variable;
            String name;
            ASTPrimarySuffix primarySuffix;
            ASTLocalVariableDeclaration lvd = (ASTLocalVariableDeclaration)node.jjtGetChild(0);
            ASTVariableDeclaratorId vdId = (ASTVariableDeclaratorId)lvd.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
            ASTExpression exp = (ASTExpression)lvd.getFirstDescendantOfType(ASTExpression.class);
            if (exp != null && (primarySuffix = (ASTPrimarySuffix)exp.getFirstDescendantOfType(ASTPrimarySuffix.class)) != null && "append".equals(name = primarySuffix.getImage()) && this.isAStringBuilderBuffer(primarySuffix, variable = vdId.getImage())) {
                return variable;
            }
        }
        return null;
    }

    private boolean isAStringBuilderBuffer(AbstractJavaNode node, String name) {
        Map declarations = node.getScope().getDeclarations(VariableNameDeclaration.class);
        for (VariableNameDeclaration decl : declarations.keySet()) {
            if (!decl.getName().equals(name) || !TypeHelper.isExactlyAny(decl, StringBuilder.class, StringBuffer.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isFirstChild(Node node, Class<?> clazz) {
        return node.jjtGetNumChildren() == 1 && clazz.isAssignableFrom(node.jjtGetChild(0).getClass());
    }
}

