/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ClassNamingConventionsRule
extends AbstractNamingConventionRule<ASTAnyTypeDeclaration> {
    private final PropertyDescriptor<Pattern> classRegex = this.defaultProp("class", "concrete class").build();
    private final PropertyDescriptor<Pattern> abstractClassRegex = this.defaultProp("abstract class").build();
    private final PropertyDescriptor<Pattern> interfaceRegex = this.defaultProp("interface").build();
    private final PropertyDescriptor<Pattern> enumerationRegex = this.defaultProp("enum").build();
    private final PropertyDescriptor<Pattern> annotationRegex = this.defaultProp("annotation").build();
    private final PropertyDescriptor<Pattern> utilityClassRegex = this.defaultProp("utility class").defaultValue("[A-Z][a-zA-Z0-9]+(Utils?|Helper)").build();

    public ClassNamingConventionsRule() {
        this.definePropertyDescriptor(this.classRegex);
        this.definePropertyDescriptor(this.abstractClassRegex);
        this.definePropertyDescriptor(this.interfaceRegex);
        this.definePropertyDescriptor(this.enumerationRegex);
        this.definePropertyDescriptor(this.annotationRegex);
        this.definePropertyDescriptor(this.utilityClassRegex);
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
        this.addRuleChainVisit(ASTEnumDeclaration.class);
        this.addRuleChainVisit(ASTAnnotationTypeDeclaration.class);
    }

    private boolean isUtilityClass(ASTAnyTypeDeclaration node) {
        if (node.getTypeKind() != ASTAnyTypeDeclaration.TypeKind.CLASS) {
            return false;
        }
        ASTClassOrInterfaceDeclaration classNode = (ASTClassOrInterfaceDeclaration)node;
        if (classNode.getSuperClassTypeNode() != null || !classNode.getSuperInterfacesTypeNodes().isEmpty()) {
            return false;
        }
        boolean hasAny = false;
        for (ASTAnyTypeBodyDeclaration decl : classNode.getDeclarations()) {
            switch (decl.getKind()) {
                case FIELD: 
                case METHOD: {
                    boolean bl = hasAny = this.isNonPrivate(decl) && !this.isMainMethod(decl);
                    if (((AccessNode)((Object)decl.getDeclarationNode())).isStatic()) break;
                    return false;
                }
                case INITIALIZER: {
                    if (((ASTInitializer)decl.getDeclarationNode()).isStatic()) break;
                    return false;
                }
            }
        }
        return hasAny;
    }

    private boolean isNonPrivate(ASTAnyTypeBodyDeclaration decl) {
        return !((AccessNode)((Object)decl.getDeclarationNode())).isPrivate();
    }

    private boolean isMainMethod(ASTAnyTypeBodyDeclaration bodyDeclaration) {
        if (ASTAnyTypeBodyDeclaration.DeclarationKind.METHOD != bodyDeclaration.getKind()) {
            return false;
        }
        ASTMethodDeclaration decl = (ASTMethodDeclaration)bodyDeclaration.getDeclarationNode();
        return decl.isStatic() && "main".equals(decl.getMethodName()) && decl.getResultType().isVoid() && decl.getFormalParameters().getParameterCount() == 1 && String[].class.equals(decl.getFormalParameters().iterator().next().getType());
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isAbstract()) {
            this.checkMatches(node, this.abstractClassRegex, data);
        } else if (this.isUtilityClass(node)) {
            this.checkMatches(node, this.utilityClassRegex, data);
        } else if (node.isInterface()) {
            this.checkMatches(node, this.interfaceRegex, data);
        } else {
            this.checkMatches(node, this.classRegex, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        this.checkMatches(node, this.enumerationRegex, data);
        return data;
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        this.checkMatches(node, this.annotationRegex, data);
        return data;
    }

    @Override
    String defaultConvention() {
        return "[A-Z][a-zA-Z0-9]*";
    }

    @Override
    String kindDisplayName(ASTAnyTypeDeclaration node, PropertyDescriptor<Pattern> descriptor) {
        return this.isUtilityClass(node) ? "utility class" : node.getTypeKind().getPrintableName();
    }
}

