/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.List;
import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public abstract class AbstractSunSecureRule
extends AbstractJavaRule {
    protected final boolean isField(String varName, AbstractNode typeDeclaration) {
        List fds = typeDeclaration.findDescendantsOfType(ASTFieldDeclaration.class);
        if (fds != null) {
            for (ASTFieldDeclaration fd : fds) {
                ASTVariableDeclaratorId vid = (ASTVariableDeclaratorId)fd.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
                if (vid == null || !vid.hasImageEqualTo(varName)) continue;
                return true;
            }
        }
        return false;
    }

    protected final String getReturnedVariableName(ASTReturnStatement ret) {
        if (this.hasTernaryCondition(ret) && this.hasTernaryNullCheck(ret)) {
            return ((ASTName)((ASTConditionalExpression)ret.getFirstDescendantOfType(ASTConditionalExpression.class)).jjtGetChild(0).getFirstDescendantOfType(ASTName.class)).getImage();
        }
        ASTName n = (ASTName)ret.getFirstDescendantOfType(ASTName.class);
        if (n != null) {
            return n.getImage();
        }
        ASTPrimarySuffix ps = (ASTPrimarySuffix)ret.getFirstDescendantOfType(ASTPrimarySuffix.class);
        if (ps != null) {
            return ps.getImage();
        }
        return null;
    }

    private boolean hasTernaryNullCheck(ASTReturnStatement ret) {
        ASTConditionalExpression condition = (ASTConditionalExpression)ret.getFirstDescendantOfType(ASTConditionalExpression.class);
        return condition.jjtGetChild(0) instanceof ASTEqualityExpression && condition.jjtGetChild(0).hasImageEqualTo("==") && condition.jjtGetChild(0).jjtGetChild(0).hasDescendantOfType(ASTName.class) && condition.jjtGetChild(0).jjtGetChild(1).hasDescendantOfType(ASTNullLiteral.class);
    }

    private boolean hasTernaryCondition(ASTReturnStatement ret) {
        return null != ret.getFirstDescendantOfType(ASTConditionalExpression.class);
    }

    protected boolean isLocalVariable(String vn, Node node) {
        List lvars = node.findDescendantsOfType(ASTLocalVariableDeclaration.class);
        if (lvars != null) {
            for (ASTLocalVariableDeclaration lvd : lvars) {
                ASTVariableDeclaratorId vid = (ASTVariableDeclaratorId)lvd.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
                if (vid == null || !vid.hasImageEqualTo(vn)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getFirstNameImage(Node n) {
        ASTName name = (ASTName)n.getFirstDescendantOfType(ASTName.class);
        if (name != null && name.getNthParent(3) == n) {
            return name.getImage();
        }
        return null;
    }
}

