/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.util.CollectionUtil;

public class ASTClassOrInterfaceDeclaration
extends AbstractAnyTypeDeclaration {
    private boolean isLocal;
    private boolean isLocalComputed;
    private boolean isInterface;

    public ASTClassOrInterfaceDeclaration(int id) {
        super(id);
    }

    public ASTClassOrInterfaceDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    public boolean isFindBoundary() {
        return this.isNested() || this.isLocal();
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isLocal() {
        if (!this.isLocalComputed) {
            Node current;
            for (current = this.jjtGetParent(); current != null; current = current.jjtGetParent()) {
                if (current instanceof ASTAnyTypeDeclaration) {
                    this.isLocal = false;
                    break;
                }
                if (!(current instanceof ASTMethodOrConstructorDeclaration) && !(current instanceof ASTInitializer)) continue;
                this.isLocal = true;
                break;
            }
            if (current == null) {
                this.isLocal = false;
            }
            this.isLocalComputed = true;
        }
        return this.isLocal;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface() {
        this.isInterface = true;
    }

    @Override
    public ASTAnyTypeDeclaration.TypeKind getTypeKind() {
        return this.isInterface() ? ASTAnyTypeDeclaration.TypeKind.INTERFACE : ASTAnyTypeDeclaration.TypeKind.CLASS;
    }

    @Override
    public List<ASTAnyTypeBodyDeclaration> getDeclarations() {
        return ((ASTClassOrInterfaceBody)this.getFirstChildOfType(ASTClassOrInterfaceBody.class)).findChildrenOfType(ASTAnyTypeBodyDeclaration.class);
    }

    public ASTClassOrInterfaceType getSuperClassTypeNode() {
        if (this.isInterface()) {
            return null;
        }
        ASTExtendsList extendsList = (ASTExtendsList)this.getFirstChildOfType(ASTExtendsList.class);
        return extendsList == null ? null : extendsList.iterator().next();
    }

    public List<ASTClassOrInterfaceType> getSuperInterfacesTypeNodes() {
        Iterable it = (Iterable)((Object)(this.isInterface() ? (AbstractJavaNode)this.getFirstChildOfType(ASTExtendsList.class) : (AbstractJavaNode)this.getFirstChildOfType(ASTImplementsList.class)));
        return it == null ? Collections.emptyList() : CollectionUtil.toList(it.iterator());
    }
}

