/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;

public class MultiMemberVisitor
implements MemberVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private MemberVisitor[] memberVisitors;
    private int memberVisitorCount;

    public MultiMemberVisitor() {
    }

    public MultiMemberVisitor(MemberVisitor[] memberVisitors) {
        this.memberVisitors = memberVisitors;
        this.memberVisitorCount = memberVisitors.length;
    }

    public void addMemberVisitor(MemberVisitor memberVisitor) {
        this.ensureArraySize();
        this.memberVisitors[this.memberVisitorCount++] = memberVisitor;
    }

    private void ensureArraySize() {
        if (this.memberVisitors == null) {
            this.memberVisitors = new MemberVisitor[5];
        } else if (this.memberVisitors.length == this.memberVisitorCount) {
            MemberVisitor[] newMemberVisitors = new MemberVisitor[this.memberVisitorCount + 5];
            System.arraycopy(this.memberVisitors, 0, newMemberVisitors, 0, this.memberVisitorCount);
            this.memberVisitors = newMemberVisitors;
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        for (int index = 0; index < this.memberVisitorCount; ++index) {
            this.memberVisitors[index].visitProgramField(programClass, programField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        for (int index = 0; index < this.memberVisitorCount; ++index) {
            this.memberVisitors[index].visitProgramMethod(programClass, programMethod);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        for (int index = 0; index < this.memberVisitorCount; ++index) {
            this.memberVisitors[index].visitLibraryField(libraryClass, libraryField);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        for (int index = 0; index < this.memberVisitorCount; ++index) {
            this.memberVisitors[index].visitLibraryMethod(libraryClass, libraryMethod);
        }
    }
}

