/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.UpdateStatement;
import org.apache.ws.jaxme.sqls.impl.TableImpl;

public class ViewImpl
extends TableImpl {
    private final SelectStatement stmt;

    public ViewImpl(SelectStatement pSelectStatement, Table.Name pName) {
        super(pSelectStatement.getSelectTableReference().getTable().getSchema(), pName == null ? pSelectStatement.getTableReference().getTable().getName() : pName);
        this.stmt = pSelectStatement;
    }

    public Iterator getColumns() {
        ArrayList<ViewColumnImpl> result = new ArrayList<ViewColumnImpl>();
        Iterator iter = this.stmt.getResultColumns();
        while (iter.hasNext()) {
            ColumnReference col = (ColumnReference)iter.next();
            result.add(new ViewColumnImpl(col));
        }
        return result.iterator();
    }

    public Column newColumn(Column.Name pName, Column.Type pType) {
        throw new IllegalStateException("A views columns cannot be changed.");
    }

    public Column newColumn(String pName, Column.Type pType) {
        throw new IllegalStateException("A views columns cannot be changed.");
    }

    public Column getColumn(Column.Name pName) {
        if (pName == null) {
            throw new NullPointerException("Column names must not be null.");
        }
        Iterator iter = this.stmt.getResultColumns();
        while (iter.hasNext()) {
            ColumnReference col = (ColumnReference)iter.next();
            Column.Name alias = col.getAlias();
            if (alias == null) {
                alias = col.getColumn().getName();
            }
            if (!alias.equals(pName)) continue;
            return new ViewColumnImpl(col);
        }
        return null;
    }

    public Index newKey() {
        throw new IllegalStateException("A view cannot have keys.");
    }

    public Index newIndex() {
        throw new IllegalStateException("A view cannot have indexes.");
    }

    public Index newPrimaryKey() {
        throw new IllegalStateException("A view cannot have a primary key.");
    }

    public ForeignKey newForeignKey(Table pReferencedTable) {
        throw new IllegalStateException("A view cannot have foreign keys.");
    }

    public InsertStatement getInsertStatement() {
        throw new IllegalStateException("A view is not updateable.");
    }

    public UpdateStatement getUpdateStatement() {
        throw new IllegalStateException("A view is not updateable.");
    }

    public DeleteStatement getDeleteStatement() {
        throw new IllegalStateException("A view is not updateable.");
    }

    public Index getPrimaryKey() {
        throw new IllegalStateException("A view cannot have a primary key.");
    }

    public Iterator getIndexes() {
        throw new IllegalStateException("A view cannot have indexes.");
    }

    public Iterator getForeignKeys() {
        throw new IllegalStateException("A view cannot have foreign keys.");
    }

    public SelectStatement getViewStatement() {
        return this.stmt;
    }

    private class ViewColumnImpl
    implements Column {
        private final Column.Name colName;
        private final Column col;
        private Object data;

        private ViewColumnImpl(ColumnReference pColumn) {
            this.col = pColumn.getColumn();
            Column.Name alias = pColumn.getAlias();
            this.colName = alias == null ? this.col.getName() : alias;
        }

        public Table getTable() {
            return ViewImpl.this;
        }

        public Column.Name getName() {
            return this.colName;
        }

        public String getQName() {
            return this.getTable() + "." + this.getName();
        }

        public Column.Type getType() {
            return this.col.getType();
        }

        public boolean isPrimaryKeyPart() {
            return false;
        }

        public void setNullable(boolean pNullable) {
            throw new IllegalStateException("Unable to set a view columns 'Nullable' property.");
        }

        public boolean isNullable() {
            return this.col.isNullable();
        }

        public boolean isStringColumn() {
            return this.col.isStringColumn();
        }

        public boolean isBinaryColumn() {
            return this.col.isBinaryColumn();
        }

        public void setCustomData(Object pData) {
            this.data = pData;
        }

        public Object getCustomData() {
            return this.data;
        }

        public boolean isVirtual() {
            return false;
        }
    }
}

