/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnSet;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.impl.ColumnImpl;
import org.apache.ws.jaxme.sqls.impl.ColumnSetImpl;

public class ForeignKeyImpl
extends ColumnSetImpl
implements ForeignKey {
    private Table referencedTable;
    private ForeignKey.Mode onDelete;
    private ForeignKey.Mode onUpdate;
    public List references = new ArrayList();

    protected ForeignKeyImpl(Table pTable, Table pReferencedTable) {
        super(pTable);
        if (pReferencedTable == null) {
            throw new NullPointerException("The referenced table must not be null.");
        }
        this.referencedTable = pReferencedTable;
    }

    public Table getReferencedTable() {
        return this.referencedTable;
    }

    public void setOnDelete(ForeignKey.Mode pMode) {
        this.onDelete = pMode;
    }

    public ForeignKey.Mode getOnDelete() {
        return this.onDelete;
    }

    public void setOnUpdate(ForeignKey.Mode pMode) {
        this.onUpdate = pMode;
    }

    public ForeignKey.Mode getOnUpdate() {
        return this.onUpdate;
    }

    public void addColumnLink(Column pColumn, Column pReferencedColumn) {
        this.addColumnReference(new ColumnReferenceImpl(pColumn, pReferencedColumn));
    }

    public void addColumnReference(ForeignKey.ColumnLink pReference) {
        Column localColumn = pReference.getLocalColumn();
        if (!this.getTable().equals(localColumn.getTable())) {
            throw new IllegalStateException("The local column " + localColumn.getQName() + " is not from the local table " + this.getTable().getQName());
        }
        Column referencedColumn = pReference.getReferencedColumn();
        if (!this.getReferencedTable().equals(referencedColumn.getTable())) {
            throw new IllegalStateException("The referenced column " + referencedColumn.getQName() + " is not from the referenced table " + this.getReferencedTable().getQName());
        }
        this.references.add(pReference);
    }

    public void addColumnLink(Column.Name pName, Column.Name pReferencedName) {
        Column localColumn = this.getTable().getColumn(pName);
        if (localColumn == null) {
            throw new NullPointerException("The local table " + this.getTable().getQName() + " doesn't contain a column " + pName);
        }
        Column referencedColumn = this.getReferencedTable().getColumn(pReferencedName);
        if (referencedColumn == null) {
            throw new NullPointerException("The referenced table " + this.getReferencedTable().getName() + " doesn't contain a column " + pReferencedName);
        }
        this.addColumnLink(localColumn, referencedColumn);
    }

    public void addColumnLink(String pName, String pReferencedName) {
        this.addColumnLink(new ColumnImpl.NameImpl(pName), new ColumnImpl.NameImpl(pReferencedName));
    }

    public Iterator getColumnLinks() {
        return this.references.iterator();
    }

    public Iterator getColumns() {
        return new Iterator(){
            Iterator inner;
            {
                this.inner = ForeignKeyImpl.this.getColumnLinks();
            }

            public boolean hasNext() {
                return this.inner.hasNext();
            }

            public void remove() {
                this.inner.remove();
            }

            public Object next() {
                ForeignKey.ColumnLink link = (ForeignKey.ColumnLink)this.inner.next();
                return link.getLocalColumn();
            }
        };
    }

    public ColumnSet getReferencedColumns() {
        return new ColumnSet(){

            public Table getTable() {
                return ForeignKeyImpl.this.getReferencedTable();
            }

            public Iterator getColumns() {
                return new Iterator(this){
                    private Iterator inner;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.inner = 2.access$000(this.this$1).getColumnLinks();
                    }

                    public Object next() {
                        return ((ForeignKey.ColumnLink)this.inner.next()).getReferencedColumn();
                    }

                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    public void remove() {
                        this.inner.remove();
                    }
                };
            }

            static /* synthetic */ ForeignKeyImpl access$000(2 x0) {
                return x0.ForeignKeyImpl.this;
            }
        };
    }

    public static class ColumnReferenceImpl
    implements ForeignKey.ColumnLink {
        private final Column localColumn;
        private final Column referencedColumn;

        public ColumnReferenceImpl(Column pLocalColumn, Column pReferencedColumn) {
            if (pLocalColumn == null) {
                throw new NullPointerException("The local column must not be null.");
            }
            if (pReferencedColumn == null) {
                throw new NullPointerException("The referenced column must not be null.");
            }
            this.localColumn = pLocalColumn;
            this.referencedColumn = pReferencedColumn;
        }

        public Column getLocalColumn() {
            return this.localColumn;
        }

        public Column getReferencedColumn() {
            return this.referencedColumn;
        }
    }
}

