/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.Parameter;

public class ProxyGenerator {
    private JavaQName extendedClass;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$NullPointerException;
    static /* synthetic */ Class class$java$lang$ClassCastException;

    public JavaQName getExtendedClass() {
        return this.extendedClass;
    }

    public void setExtendedClass(JavaQName pExtendedClass) {
        this.extendedClass = pExtendedClass;
    }

    protected GeneratedMethod getGeneratedMethod(Method pMethod) {
        GeneratedMethod result = new GeneratedMethod();
        result.setDeclaringInterface(pMethod.getDeclaringClass());
        result.setName(pMethod.getName());
        result.setParameters(pMethod.getParameterTypes());
        return result;
    }

    protected JavaMethod getInterfaceMethod(JavaSource pJs, InterfaceDescription pInterfaceDescription, Method pMethod) {
        JavaMethod jm = pJs.newJavaMethod(pMethod);
        Parameter[] parameters = jm.getParams();
        ArrayList<String> callParameters = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (callParameters.size() > 0) {
                callParameters.add(", ");
            }
            callParameters.add(parameter.getName());
        }
        jm.addLine(Void.TYPE.equals(pMethod.getReturnType()) ? "" : " return ", "((", pInterfaceDescription.getInterface(), ") backingObject).", pMethod.getName(), "(", callParameters, ");");
        return jm;
    }

    protected void generateInterfaceMethods(JavaSource pJs, Map pGeneratedMethods, InterfaceDescription pDescription) {
        Class c = pDescription.interfaceClass;
        Method[] methods = c.getMethods();
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                GeneratedMethod generatedMethod = this.getGeneratedMethod(method);
                GeneratedMethod existingMethod = (GeneratedMethod)pGeneratedMethods.get(generatedMethod);
                if (existingMethod != null) {
                    if (generatedMethod.getDeclaringInterface().equals(existingMethod.getDeclaringInterface())) continue;
                    System.err.println("The interfaces " + existingMethod.getDeclaringInterface().getName() + "." + existingMethod.getName() + " and " + generatedMethod.getDeclaringInterface().getName() + "." + generatedMethod.getName() + " are identical, ignoring the latter.");
                    continue;
                }
                pGeneratedMethods.put(generatedMethod, generatedMethod);
                generatedMethod.setMethod(this.getInterfaceMethod(pJs, pDescription, method));
            }
        }
    }

    protected JavaConstructor getConstructor(JavaSource pJs, InterfaceDescription[] pInterfaces) {
        JavaConstructor jcon = pJs.newJavaConstructor(JavaSource.PROTECTED);
        jcon.addParam(class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object, "o");
        jcon.addIf("o == null");
        jcon.addThrowNew(class$java$lang$NullPointerException == null ? (class$java$lang$NullPointerException = ProxyGenerator.class$("java.lang.NullPointerException")) : class$java$lang$NullPointerException, (Object)JavaSource.getQuoted("The supplied object must not be null."));
        jcon.addEndIf();
        for (int i = 0; i < pInterfaces.length; ++i) {
            if (!pInterfaces[i].isMandatory) continue;
            jcon.addIf("!(o instanceof ", (Object)pInterfaces[i].getInterface(), (Object)")");
            jcon.addThrowNew(class$java$lang$ClassCastException == null ? ProxyGenerator.class$("java.lang.ClassCastException") : class$java$lang$ClassCastException, (Object)JavaSource.getQuoted("The supplied instance of "), (Object)" + o.getClass().getName() + ", (Object)JavaSource.getQuoted(" is not implementing "), (Object)" + ", (Object)pInterfaces[i].getInterface(), (Object)".class.getName()");
            jcon.addEndIf();
        }
        jcon.addLine("backingObject = o;");
        return jcon;
    }

    protected JavaSource getJavaSource(JavaSourceFactory pFactory, JavaQName pTargetName) {
        return pFactory.newJavaSource(pTargetName, JavaSource.PUBLIC);
    }

    protected JavaField getBackingObjectField(JavaSource pJs, InterfaceDescription[] pInterfaces) {
        return pJs.newJavaField("backingObject", class$java$lang$Object == null ? (class$java$lang$Object = ProxyGenerator.class$("java.lang.Object")) : class$java$lang$Object, JavaSource.PRIVATE);
    }

    public JavaSource generate(JavaSourceFactory pFactory, JavaQName pTargetName, InterfaceDescription[] pInterfaces) {
        for (int i = 0; i < pInterfaces.length; ++i) {
            if (pInterfaces[i] != null && pInterfaces[i].interfaceClass != null) continue;
            throw new NullPointerException("The interfaces being implemented must be non-null");
        }
        JavaSource js = this.getJavaSource(pFactory, pTargetName);
        if (this.getExtendedClass() != null) {
            js.addExtends(this.getExtendedClass());
        }
        for (int i = 0; i < pInterfaces.length; ++i) {
            js.addImplements(pInterfaces[i].getInterface());
        }
        this.getBackingObjectField(js, pInterfaces);
        this.getConstructor(js, pInterfaces);
        HashMap methods = new HashMap();
        for (int i = 0; i < pInterfaces.length; ++i) {
            this.generateInterfaceMethods(js, methods, pInterfaces[i]);
        }
        return js;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class InterfaceDescription {
        Class interfaceClass;
        boolean isMandatory = true;

        public void setInterfaceName(String pName) throws ClassNotFoundException {
            ClassNotFoundException ex;
            block7: {
                Class<?> c;
                ex = null;
                try {
                    c = Class.forName(pName);
                    if (c != null) {
                        this.setInterface(c);
                        return;
                    }
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                }
                try {
                    c = Thread.currentThread().getContextClassLoader().loadClass(pName);
                    if (c != null) {
                        this.setInterface(c);
                        return;
                    }
                }
                catch (ClassNotFoundException e) {
                    if (ex != null) break block7;
                    ex = e;
                }
            }
            if (ex == null) {
                ex = new ClassNotFoundException("Failed to load class: " + pName);
            }
            throw ex;
        }

        public void setInterface(Class pClass) {
            if (!pClass.isInterface()) {
                throw new IllegalArgumentException("The class " + pClass.getName() + " is not an interface.");
            }
            this.interfaceClass = pClass;
        }

        public Class getInterface() {
            return this.interfaceClass;
        }

        public void setMandatory(boolean pMandatory) {
            this.isMandatory = pMandatory;
        }

        public boolean isMandatory() {
            return this.isMandatory;
        }
    }

    protected static class GeneratedMethod
    implements Serializable,
    Comparable {
        private JavaMethod method;
        private String name;
        private Class[] parameters;
        private Class declaringInterface;

        protected GeneratedMethod() {
        }

        public void setMethod(JavaMethod pMethod) {
            this.method = pMethod;
        }

        public JavaMethod getMethod() {
            return this.method;
        }

        public void setName(String pName) {
            this.name = pName;
        }

        public String getName() {
            return this.name;
        }

        public void setParameters(Class[] pParameters) {
            this.parameters = pParameters;
        }

        public Class[] getParameters() {
            return this.parameters;
        }

        public void setDeclaringInterface(Class pInterface) {
            this.declaringInterface = pInterface;
        }

        public Class getDeclaringInterface() {
            return this.declaringInterface;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof GeneratedMethod)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public int compareTo(Object o) {
            GeneratedMethod gm = (GeneratedMethod)o;
            if (this.name == null) {
                if (gm.name != null) {
                    return -1;
                }
            } else {
                if (gm.name == null) {
                    return 1;
                }
                int result = this.name.compareTo(gm.name);
                if (result != 0) {
                    return result;
                }
            }
            if (this.parameters == null) {
                if (gm.parameters != null) {
                    return -1;
                }
            } else {
                if (gm.parameters == null) {
                    return 1;
                }
                if (this.parameters.length != gm.parameters.length) {
                    return this.parameters.length - gm.parameters.length;
                }
                for (int i = 0; i < this.parameters.length; ++i) {
                    Class c1 = this.parameters[i];
                    Class c2 = gm.parameters[i];
                    if (c1 == null) {
                        if (c2 == null) continue;
                        return -1;
                    }
                    if (c2 == null) {
                        return 1;
                    }
                    int result = c1.getName().compareTo(c2.getName());
                    if (result == 0) continue;
                    return result;
                }
            }
            return 0;
        }

        public int hashCode() {
            int result;
            int n = result = this.name == null ? 0 : this.name.hashCode();
            if (this.parameters != null) {
                result += this.parameters.length;
                for (int i = 0; i < this.parameters.length; ++i) {
                    Class c = this.parameters[i];
                    if (c == null) continue;
                    result += c.getName().hashCode();
                }
            }
            return result;
        }
    }
}

