/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.pattern.ProxyGenerator;

public class ChainGenerator {
    private Class controllerInterface;
    private JavaQName chainInterface;
    private JavaQName proxyClass;
    private JavaQName implClass;
    static /* synthetic */ Class class$java$lang$NullPointerException;

    public void setControllerInterfaceName(String pInterfaceName) throws ClassNotFoundException {
        Class<?> c;
        ClassNotFoundException ex;
        block7: {
            ex = null;
            c = null;
            try {
                c = Class.forName(pInterfaceName);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
            if (c == null) {
                try {
                    c = Thread.currentThread().getContextClassLoader().loadClass(pInterfaceName);
                }
                catch (ClassNotFoundException e) {
                    if (ex != null) break block7;
                    e = ex;
                }
            }
        }
        if (c == null) {
            if (ex == null) {
                ex = new ClassNotFoundException("Failed to load class: " + pInterfaceName);
            }
            throw ex;
        }
        this.setControllerInterface(c);
    }

    public void setControllerInterface(Class pInterface) {
        if (!pInterface.isInterface()) {
            throw new ClassCastException("The controller must be an interface.");
        }
        this.controllerInterface = pInterface;
    }

    public Class getControllerInterface() {
        return this.controllerInterface;
    }

    public void setChainInterfaceName(String pInterfaceName) {
        JavaQName qName = JavaQNameImpl.getInstance(pInterfaceName, true);
        this.setChainInterface(qName);
    }

    public void setChainInterface(JavaQName pInterface) {
        this.chainInterface = pInterface;
    }

    public JavaQName getChainInterface() {
        return this.chainInterface;
    }

    public void setProxyClassName(String pClassName) {
        JavaQName qName = JavaQNameImpl.getInstance(pClassName, true);
        this.setProxyClass(qName);
    }

    public void setProxyClass(JavaQName pClassName) {
        this.proxyClass = pClassName;
    }

    public JavaQName getProxyClass() {
        if (this.proxyClass == null) {
            JavaQName chainClass = this.getChainInterface();
            if (chainClass == null) {
                return null;
            }
            return JavaQNameImpl.getInstance(chainClass.getPackageName(), chainClass.getClassName() + "Impl");
        }
        return this.proxyClass;
    }

    public void setImplementationClassName(String pClassName) {
        this.setImplementationClass(JavaQNameImpl.getInstance(pClassName, true));
    }

    public void setImplementationClass(JavaQName pClassName) {
        this.implClass = pClassName;
    }

    public JavaQName getImplementationClass() {
        if (this.implClass == null) {
            if (this.controllerInterface == null) {
                return null;
            }
            JavaQName controllerClass = JavaQNameImpl.getInstance(this.controllerInterface);
            return JavaQNameImpl.getInstance(controllerClass.getPackageName(), controllerClass.getClassName() + "Impl");
        }
        return this.implClass;
    }

    public void finish() {
        if (this.controllerInterface == null) {
            throw new NullPointerException("A controller interface must be given.");
        }
        if (this.chainInterface == null) {
            throw new NullPointerException("A chain interface must be given.");
        }
    }

    public JavaSource[] generate(JavaSourceFactory pFactory) {
        ProxyGenerator.InterfaceDescription controllerDescription = new ProxyGenerator.InterfaceDescription();
        this.controllerInterface = this.getControllerInterface();
        controllerDescription.setInterface(this.controllerInterface);
        controllerDescription.setMandatory(true);
        ProxyGenerator.InterfaceDescription[] interfaces = new ProxyGenerator.InterfaceDescription[]{controllerDescription};
        ProxyInterfaceGenerator proxyInterfaceGenerator = new ProxyInterfaceGenerator();
        JavaSource proxyInterface = ((ProxyGenerator)proxyInterfaceGenerator).generate(pFactory, this.getChainInterface(), interfaces);
        proxyInterface.setType(JavaSource.INTERFACE);
        ProxyImplementationGenerator proxyImpGenerator = new ProxyImplementationGenerator();
        JavaSource proxyImplementation = ((ProxyGenerator)proxyImpGenerator).generate(pFactory, this.getProxyClass(), interfaces);
        ControllerImplementationGenerator controllerImplementationGenerator = new ControllerImplementationGenerator();
        JavaSource controllerImplementation = ((ProxyGenerator)controllerImplementationGenerator).generate(pFactory, this.getImplementationClass(), interfaces);
        return new JavaSource[]{controllerImplementation, proxyInterface, proxyImplementation};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ControllerImplementationGenerator
    extends ProxyGenerator {
        private ControllerImplementationGenerator() {
        }

        protected JavaField getBackingObjectField(JavaSource pJs, ProxyGenerator.InterfaceDescription[] pInterfaces) {
            return pJs.newJavaField("backingObject", ChainGenerator.this.getChainInterface(), JavaSource.PRIVATE);
        }

        protected JavaConstructor getConstructor(JavaSource pJs, ProxyGenerator.InterfaceDescription[] pInterfaces) {
            JavaConstructor jcon = pJs.newJavaConstructor(JavaSource.PUBLIC);
            jcon.addParam(ChainGenerator.this.getChainInterface(), "o");
            jcon.addIf("o == null");
            jcon.addThrowNew(class$java$lang$NullPointerException == null ? (class$java$lang$NullPointerException = ChainGenerator.class$("java.lang.NullPointerException")) : class$java$lang$NullPointerException, (Object)JavaSource.getQuoted("The supplied object must not be null."));
            jcon.addEndIf();
            jcon.addLine("backingObject = o;");
            return jcon;
        }

        public JavaMethod getInterfaceMethod(JavaSource pSource, ProxyGenerator.InterfaceDescription pDescription, Method pMethod) {
            JavaMethod jm = pSource.newJavaMethod(pMethod);
            Parameter[] parameters = jm.getParams();
            ArrayList<String> callParameters = new ArrayList<String>();
            callParameters.add("this");
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                callParameters.add(", ");
                callParameters.add(parameter.getName());
            }
            jm.addLine(Void.TYPE.equals(pMethod.getReturnType()) ? "" : " return ", "backingObject.", pMethod.getName(), "(", callParameters, ");");
            return jm;
        }

        protected JavaMethod getGetHeadOfChainMethod(JavaSource pSource) {
            JavaMethod jm = pSource.newJavaMethod("getHeadOfChain", ChainGenerator.this.getChainInterface(), JavaSource.PUBLIC);
            jm.addLine("return backingObject;");
            return jm;
        }

        public JavaSource generate(JavaSourceFactory pImplementationFactory, JavaQName pTargetClass, ProxyGenerator.InterfaceDescription[] pDescription) {
            JavaSource result = super.generate(pImplementationFactory, pTargetClass, pDescription);
            this.getGetHeadOfChainMethod(result);
            return result;
        }
    }

    private class ProxyImplementationGenerator
    extends ProxyGenerator {
        private ProxyImplementationGenerator() {
        }

        protected JavaField getBackingObjectField(JavaSource pJs, ProxyGenerator.InterfaceDescription[] pInterfaces) {
            return pJs.newJavaField("backingObject", ChainGenerator.this.getChainInterface(), JavaSource.PRIVATE);
        }

        protected JavaConstructor getConstructor(JavaSource pJs, ProxyGenerator.InterfaceDescription[] pInterfaces) {
            JavaConstructor jcon = pJs.newJavaConstructor(JavaSource.PROTECTED);
            jcon.addParam(ChainGenerator.this.getChainInterface(), "o");
            jcon.addIf("o == null");
            jcon.addThrowNew(class$java$lang$NullPointerException == null ? (class$java$lang$NullPointerException = ChainGenerator.class$("java.lang.NullPointerException")) : class$java$lang$NullPointerException, (Object)JavaSource.getQuoted("The supplied object must not be null."));
            jcon.addEndIf();
            jcon.addLine("backingObject = o;");
            return jcon;
        }

        public JavaMethod getInterfaceMethod(JavaSource pSource, ProxyGenerator.InterfaceDescription pDescription, Method pMethod) {
            JavaMethod jm = pSource.newJavaMethod(pMethod);
            Parameter[] parameters = jm.getParams();
            JavaQName controllerInterfaceQName = JavaQNameImpl.getInstance(ChainGenerator.this.getControllerInterface());
            jm.clearParams();
            jm.addParam(controllerInterfaceQName, "pController");
            for (int i = 0; i < parameters.length; ++i) {
                jm.addParam(parameters[i]);
            }
            ArrayList<String> callParameters = new ArrayList<String>();
            callParameters.add("pController");
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                callParameters.add(", ");
                callParameters.add(parameter.getName());
            }
            jm.addLine(Void.TYPE.equals(pMethod.getReturnType()) ? "" : " return ", "backingObject.", pMethod.getName(), "(", callParameters, ");");
            return jm;
        }

        public JavaSource generate(JavaSourceFactory pImplementationFactory, JavaQName pTargetClass, ProxyGenerator.InterfaceDescription[] pDescription) {
            JavaSource result = super.generate(pImplementationFactory, pTargetClass, pDescription);
            result.clearImplements();
            result.addImplements(ChainGenerator.this.getChainInterface());
            return result;
        }
    }

    private class ProxyInterfaceGenerator
    extends ProxyGenerator {
        private ProxyInterfaceGenerator() {
        }

        public JavaMethod getInterfaceMethod(JavaSource pSource, ProxyGenerator.InterfaceDescription pDescription, Method pMethod) {
            JavaMethod jm = pSource.newJavaMethod(pMethod);
            Parameter[] parameters = jm.getParams();
            JavaQName controllerInterfaceQName = JavaQNameImpl.getInstance(ChainGenerator.this.getControllerInterface());
            jm.clearParams();
            jm.addParam(controllerInterfaceQName, "pController");
            for (int i = 0; i < parameters.length; ++i) {
                jm.addParam(parameters[i]);
            }
            return jm;
        }

        public JavaSource generate(JavaSourceFactory pInterfaceFactory, JavaQName pTargetClass, ProxyGenerator.InterfaceDescription[] pDescription) {
            JavaSource result = super.generate(pInterfaceFactory, pTargetClass, pDescription);
            result.clearImplements();
            return result;
        }
    }
}

