/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import org.apache.ws.jaxme.js.IndentationEngineImpl;
import org.apache.ws.jaxme.js.JavaComment;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;

public abstract class JavaSourceObject
extends IndentationEngineImpl {
    private String name;
    private boolean isFinal = false;
    private boolean isStatic = false;
    private JavaQName type;
    private JavaSource.Protection protection = JavaSource.DEFAULT_PROTECTION;
    private JavaComment comment;
    private boolean bAbstract = false;
    private JavaSource javaSource;

    protected JavaSourceObject(String pName, JavaQName pType, JavaSource.Protection pProtection) {
        this.setName(pName);
        this.setType(pType);
        this.setProtection(pProtection);
    }

    protected JavaSourceObject(String pName, JavaQName pType) {
        this(pName, pType, null);
    }

    protected JavaSourceObject(String pName, String pType, JavaSource.Protection pProtection) {
        this.setName(pName);
        if (pType == null) {
            throw new NullPointerException("Type must not be null");
        }
        int offset = pType.indexOf(46);
        if (offset == -1) {
            this.setType(JavaQNameImpl.getInstance(pType));
        } else {
            this.setType(JavaQNameImpl.getInstance(pType.substring(0, offset), pType.substring(offset + 1)));
        }
        this.setProtection(pProtection);
    }

    protected JavaSourceObject(String pName, String pType) {
        this(pName, pType, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean pFinal) {
        this.isFinal = pFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean pStatic) {
        this.isStatic = pStatic;
    }

    public JavaQName getType() {
        return this.type;
    }

    public void setType(JavaQName t) {
        this.type = t;
    }

    public JavaSource.Protection getProtection() {
        return this.protection;
    }

    public void setProtection(JavaSource.Protection p) {
        this.protection = p == null ? JavaSource.DEFAULT_PROTECTION : p;
    }

    public JavaComment getComment() {
        return this.comment;
    }

    public JavaComment newComment() {
        if (this.comment == null) {
            this.comment = new JavaComment();
            return this.comment;
        }
        throw new IllegalStateException("A Javadoc comment has already been created for this object.");
    }

    public boolean isAbstract() {
        return this.bAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.bAbstract = isAbstract;
    }

    protected void setJavaSource(JavaSource pSource) {
        this.javaSource = pSource;
    }

    public JavaSource getJavaSource() {
        return this.javaSource;
    }
}

