/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.io.IOException;
import org.apache.ws.jaxme.js.AbstractJavaMethod;
import org.apache.ws.jaxme.js.IndentationTarget;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.Parameter;

public class JavaMethod
extends AbstractJavaMethod {
    private boolean isSynchronized;

    JavaMethod(String pName, JavaQName pType, JavaSource.Protection pProtection) {
        super(pName, pType, pProtection);
    }

    public void setSynchronized(boolean pSynchronized) {
        this.isSynchronized = pSynchronized;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    protected void writeHeader(IndentationTarget pTarget) throws IOException {
        pTarget.indent(0);
        JavaSource.Protection protection = this.getProtection();
        if (protection != null && !protection.equals(JavaSource.DEFAULT_PROTECTION)) {
            pTarget.write(this.getProtection().toString());
            pTarget.write(" ");
        }
        if (this.isStatic()) {
            pTarget.write("static ");
        }
        if (this.isFinal()) {
            pTarget.write("final ");
        }
        if (this.isAbstract()) {
            pTarget.write("abstract ");
        }
        if (this.isSynchronized() && !pTarget.isInterface()) {
            pTarget.write("synchronized ");
        }
        pTarget.write(pTarget.asString(this.getType()));
        pTarget.write(" ");
        pTarget.write(this.getName());
        pTarget.write("(");
        Parameter[] params = this.getParams();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                pTarget.write(", ");
            }
            Parameter p = params[i];
            pTarget.write(pTarget.asString(p.getType()));
            pTarget.write(" ");
            pTarget.write(p.getName());
        }
        pTarget.write(")");
        JavaQName[] exceptions = this.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            if (i > 0) {
                pTarget.write(", ");
            } else {
                pTarget.write(" throws ");
            }
            pTarget.write(pTarget.asString(exceptions[i]));
        }
        if (pTarget.isInterface() || this.isAbstract()) {
            pTarget.write(";");
        } else {
            pTarget.write(" {");
        }
        pTarget.write();
    }

    public String getLoggingSignature() {
        StringBuffer result = new StringBuffer(this.getName());
        Parameter[] params = this.getParams();
        if (params.length > 0) {
            result.append('(');
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    result.append(',');
                }
                result.append(params[i].getType().getClassName());
            }
            result.append(')');
        }
        return result.toString();
    }

    public boolean isVoid() {
        return this.getType().equals(JavaQNameImpl.VOID);
    }
}

