/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.js.ConditionalIndentationJavaSourceObject;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.Parameter;

public abstract class AbstractJavaMethod
extends ConditionalIndentationJavaSourceObject {
    private List exceptions = new ArrayList();
    private List params = new ArrayList();

    public AbstractJavaMethod(String pName, JavaQName pType, JavaSource.Protection pProtection) {
        super(pName, pType, pProtection);
    }

    public boolean isThrowing(JavaQName e) {
        if (e == null) {
            throw new NullPointerException("The exception argument must not be null.");
        }
        Iterator iter = this.exceptions.iterator();
        while (iter.hasNext()) {
            if (!e.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isThrowing(Class e) {
        if (e == null) {
            throw new NullPointerException("The exception argument must not be null.");
        }
        return this.isThrowing(JavaQNameImpl.getInstance(e));
    }

    public void addThrows(JavaQName e) {
        if (e == null) {
            throw new NullPointerException("The exception argument must not be null.");
        }
        this.exceptions.add(e);
    }

    public void addThrows(Class e) {
        if (e == null) {
            throw new NullPointerException("The exception argument must not be null.");
        }
        this.exceptions.add(JavaQNameImpl.getInstance(e));
    }

    public void addThrows(String e) {
        this.exceptions.add(JavaQNameImpl.getInstance(e));
        if (e == null) {
            throw new NullPointerException("The exception argument must not be null.");
        }
    }

    public void addParam(String p) {
        if (p == null) {
            throw new NullPointerException("param argument must not be null");
        }
        StringTokenizer st = new StringTokenizer(p);
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("param argument must have two tokens: type name");
        }
        String type = st.nextToken();
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("param argument must have two tokens: type name");
        }
        String name = st.nextToken();
        if (st.hasMoreTokens()) {
            throw new IllegalArgumentException("param argument must have exactly two tokens: type name");
        }
        this.addParam(type, name);
    }

    public void addParam(String p, String v) {
        if (p == null) {
            throw new NullPointerException("param argument must not be null");
        }
        int offset = (p = p.trim()).indexOf(46);
        if (offset == -1) {
            this.addParam(JavaQNameImpl.getInstance(p), v);
        } else {
            this.addParam(JavaQNameImpl.getInstance(p.substring(0, offset), p.substring(offset + 1)), v);
        }
    }

    public Parameter addParam(Class p, String v) {
        return this.addParam(JavaQNameImpl.getInstance(p), v);
    }

    public Parameter addParam(JavaQName pType, String pName) {
        if (pType == null) {
            throw new NullPointerException("Type argument must not be null");
        }
        if (pName == null) {
            throw new NullPointerException("Parameter name argument must not be null");
        }
        Parameter p = new Parameter(pType, pName);
        this.params.add(p);
        return p;
    }

    public Parameter addParam(Parameter pParam) {
        return this.addParam(pParam.getType(), pParam.getName());
    }

    public void clearParams() {
        this.params.clear();
    }

    public JavaQName[] getExceptions() {
        return this.exceptions.toArray(new JavaQName[this.exceptions.size()]);
    }

    public Parameter[] getParams() {
        return this.params.toArray(new Parameter[this.params.size()]);
    }
}

