/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo.rpc;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Platform;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.remoting.exchange.ResponseCallback;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Future;

@Activate(group={"provider", "consumer"}, value={"tracing"})
public final class TracingFilter
implements Filter {
    Tracer tracer;
    TraceContext.Extractor<Map<String, String>> extractor;
    TraceContext.Injector<Map<String, String>> injector;
    static final Propagation.Getter<Map<String, String>, String> GETTER = new Propagation.Getter<Map<String, String>, String>(){

        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key);
        }

        public String toString() {
            return "Map::get";
        }
    };
    static final Propagation.Setter<Map<String, String>, String> SETTER = new Propagation.Setter<Map<String, String>, String>(){

        public void put(Map<String, String> carrier, String key, String value) {
            carrier.put(key, value);
        }

        public String toString() {
            return "Map::set";
        }
    };

    public void setTracing(Tracing tracing) {
        this.tracer = tracing.tracer();
        this.extractor = tracing.propagation().extractor(GETTER);
        this.injector = tracing.propagation().injector(SETTER);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Span span;
        Span.Kind kind;
        if (this.tracer == null) {
            return invoker.invoke(invocation);
        }
        RpcContext rpcContext = RpcContext.getContext();
        Span.Kind kind2 = kind = rpcContext.isProviderSide() ? Span.Kind.SERVER : Span.Kind.CLIENT;
        if (kind.equals((Object)Span.Kind.CLIENT)) {
            span = this.tracer.nextSpan();
            this.injector.inject(span.context(), (Object)invocation.getAttachments());
        } else {
            TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)invocation.getAttachments());
            Span span2 = span = extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
        }
        if (!span.isNoop()) {
            span.kind(kind);
            String service = invoker.getInterface().getSimpleName();
            String method = RpcUtils.getMethodName((Invocation)invocation);
            span.name(service + "/" + method);
            TracingFilter.parseRemoteAddress(rpcContext, span);
            span.start();
        }
        boolean isOneway = false;
        boolean deferFinish = false;
        try {
            Result result;
            block20: {
                Tracer.SpanInScope scope = this.tracer.withSpanInScope(span);
                try {
                    Result result2 = invoker.invoke(invocation);
                    if (result2.hasException()) {
                        TracingFilter.onError(result2.getException(), span);
                    }
                    isOneway = RpcUtils.isOneway((URL)invoker.getUrl(), (Invocation)invocation);
                    Future future = rpcContext.getFuture();
                    if (future instanceof FutureAdapter) {
                        deferFinish = true;
                        ((FutureAdapter)future).getFuture().setCallback((ResponseCallback)new FinishSpanCallback(span));
                    }
                    result = result2;
                    if (scope == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                            }
                        }
                        throw throwable;
                    }
                    catch (Error | RuntimeException e) {
                        TracingFilter.onError(e, span);
                        throw e;
                    }
                }
                scope.close();
            }
            return result;
        }
        finally {
            if (isOneway) {
                span.flush();
            } else if (!deferFinish) {
                span.finish();
            }
        }
    }

    static void parseRemoteAddress(RpcContext rpcContext, Span span) {
        InetSocketAddress remoteAddress = rpcContext.getRemoteAddress();
        if (remoteAddress == null) {
            return;
        }
        span.remoteIpAndPort(Platform.get().getHostString(remoteAddress), remoteAddress.getPort());
    }

    static void onError(Throwable error, Span span) {
        span.error(error);
        if (error instanceof RpcException) {
            span.tag("dubbo.error_code", Integer.toString(((RpcException)error).getCode()));
        }
    }

    static final class FinishSpanCallback
    implements ResponseCallback {
        final Span span;

        FinishSpanCallback(Span span) {
            this.span = span;
        }

        public void done(Object response) {
            this.span.finish();
        }

        public void caught(Throwable exception) {
            TracingFilter.onError(exception, this.span);
            this.span.finish();
        }
    }
}

