/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db;

import io.seata.common.exception.DataAccessException;
import io.seata.common.exception.StoreException;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.IOUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.store.BranchTransactionDO;
import io.seata.core.store.GlobalTransactionDO;
import io.seata.core.store.LogStore;
import io.seata.core.store.db.LogStoreSqls;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="db")
public class LogStoreDataBaseDAO
implements LogStore,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogStoreDataBaseDAO.class);
    private static final String TRANSACTION_NAME_KEY = "TRANSACTION_NAME";
    private static final int TRANSACTION_NAME_DEFAULT_SIZE = 128;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected DataSource logStoreDataSource = null;
    protected String globalTable;
    protected String brachTable;
    private String dbType;
    private int transactionNameColumnSize = 128;

    public LogStoreDataBaseDAO() {
    }

    public LogStoreDataBaseDAO(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
    }

    public void init() {
        this.globalTable = CONFIG.getConfig("store.db.global.table", "global_table");
        this.brachTable = CONFIG.getConfig("store.db.branch.table", "branch_table");
        this.dbType = CONFIG.getConfig("store.db.db-type");
        if (StringUtils.isBlank((String)this.dbType)) {
            throw new StoreException("there must be db type.");
        }
        if (this.logStoreDataSource == null) {
            throw new StoreException("there must be logStoreDataSource.");
        }
        this.initTransactionNameSize();
    }

    @Override
    public GlobalTransactionDO queryGlobalTransactionDO(String xid) {
        GlobalTransactionDO globalTransactionDO;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block5: {
            String sql = LogStoreSqls.getQueryGlobalTransactionSQL(this.globalTable, this.dbType);
            conn = null;
            ps = null;
            rs = null;
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            GlobalTransactionDO globalTransactionDO2 = this.convertGlobalTransactionDO(rs);
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
            return globalTransactionDO2;
        }
        try {
            globalTransactionDO = null;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return globalTransactionDO;
    }

    @Override
    public GlobalTransactionDO queryGlobalTransactionDO(long transactionId) {
        GlobalTransactionDO globalTransactionDO;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block5: {
            String sql = LogStoreSqls.getQueryGlobalTransactionSQLByTransactionId(this.globalTable, this.dbType);
            conn = null;
            ps = null;
            rs = null;
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setLong(1, transactionId);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            GlobalTransactionDO globalTransactionDO2 = this.convertGlobalTransactionDO(rs);
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
            return globalTransactionDO2;
        }
        try {
            globalTransactionDO = null;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return globalTransactionDO;
    }

    @Override
    public List<GlobalTransactionDO> queryGlobalTransactionDO(int[] statuses, int limit) {
        ArrayList<GlobalTransactionDO> arrayList;
        ArrayList<GlobalTransactionDO> ret = new ArrayList<GlobalTransactionDO>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < statuses.length; ++i) {
                sb.append("?");
                if (i == statuses.length - 1) continue;
                sb.append(", ");
            }
            String sql = LogStoreSqls.getQueryGlobalTransactionSQLByStatus(this.globalTable, this.dbType, sb.toString());
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < statuses.length; ++i) {
                int status = statuses[i];
                ps.setInt(i + 1, status);
            }
            ps.setInt(statuses.length + 1, limit);
            rs = ps.executeQuery();
            while (rs.next()) {
                ret.add(this.convertGlobalTransactionDO(rs));
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return arrayList;
    }

    @Override
    public boolean insertGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        boolean bl;
        String sql = LogStoreSqls.getInsertGlobalTransactionSQL(this.globalTable, this.dbType);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, globalTransactionDO.getXid());
            ps.setLong(2, globalTransactionDO.getTransactionId());
            ps.setInt(3, globalTransactionDO.getStatus());
            ps.setString(4, globalTransactionDO.getApplicationId());
            ps.setString(5, globalTransactionDO.getTransactionServiceGroup());
            String transactionName = globalTransactionDO.getTransactionName();
            transactionName = transactionName.length() > this.transactionNameColumnSize ? transactionName.substring(0, this.transactionNameColumnSize) : transactionName;
            ps.setString(6, transactionName);
            ps.setInt(7, globalTransactionDO.getTimeout());
            ps.setLong(8, globalTransactionDO.getBeginTime());
            ps.setString(9, globalTransactionDO.getApplicationData());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    @Override
    public boolean updateGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        boolean bl;
        String sql = LogStoreSqls.getUpdateGlobalTransactionStatusSQL(this.globalTable, this.dbType);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setInt(1, globalTransactionDO.getStatus());
            ps.setString(2, globalTransactionDO.getXid());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    @Override
    public boolean deleteGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        boolean bl;
        String sql = LogStoreSqls.getDeleteGlobalTransactionSQL(this.globalTable, this.dbType);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, globalTransactionDO.getXid());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    @Override
    public List<BranchTransactionDO> queryBranchTransactionDO(String xid) {
        ArrayList<BranchTransactionDO> arrayList;
        ArrayList<BranchTransactionDO> rets = new ArrayList<BranchTransactionDO>();
        String sql = LogStoreSqls.getQureyBranchTransaction(this.brachTable, this.dbType);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            rs = ps.executeQuery();
            while (rs.next()) {
                rets.add(this.convertBranchTransactionDO(rs));
            }
            arrayList = rets;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return arrayList;
    }

    @Override
    public List<BranchTransactionDO> queryBranchTransactionDO(List<String> xids) {
        ArrayList<BranchTransactionDO> i2;
        int length = xids.size();
        int retsSize = length * 3;
        ArrayList<BranchTransactionDO> rets = new ArrayList<BranchTransactionDO>(retsSize);
        StringJoiner sj = new StringJoiner(",");
        xids.stream().forEach(xid -> sj.add("?"));
        String sql = LogStoreSqls.getQureyBranchTransaction(this.brachTable, this.dbType, sj.toString());
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < length; ++i2) {
                ps.setString(i2 + 1, xids.get(i2));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                rets.add(this.convertBranchTransactionDO(rs));
            }
            i2 = rets;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return i2;
    }

    @Override
    public boolean insertBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        boolean bl;
        String sql = LogStoreSqls.getInsertBranchTransactionSQL(this.brachTable, this.dbType);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, branchTransactionDO.getXid());
            ps.setLong(2, branchTransactionDO.getTransactionId());
            ps.setLong(3, branchTransactionDO.getBranchId());
            ps.setString(4, branchTransactionDO.getResourceGroupId());
            ps.setString(5, branchTransactionDO.getResourceId());
            ps.setString(6, branchTransactionDO.getBranchType());
            ps.setInt(7, branchTransactionDO.getStatus());
            ps.setString(8, branchTransactionDO.getClientId());
            ps.setString(9, branchTransactionDO.getApplicationData());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    @Override
    public boolean updateBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        boolean bl;
        String sql = LogStoreSqls.getUpdateBranchTransactionStatusSQL(this.brachTable, this.dbType);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setInt(1, branchTransactionDO.getStatus());
            ps.setString(2, branchTransactionDO.getXid());
            ps.setLong(3, branchTransactionDO.getBranchId());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    @Override
    public boolean deleteBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String sql = LogStoreSqls.getDeleteBranchTransactionByBranchIdSQL(this.brachTable, this.dbType);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, branchTransactionDO.getXid());
            ps.setLong(2, branchTransactionDO.getBranchId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return true;
    }

    @Override
    public long getCurrentMaxSessionId(long high, long low) {
        String transMaxSql = LogStoreSqls.getQureyGlobalMax(this.globalTable, this.dbType);
        String branchMaxSql = LogStoreSqls.getQureyBranchMax(this.brachTable, this.dbType);
        long maxTransId = this.getCurrentMaxSessionId(transMaxSql, high, low);
        long maxBranchId = this.getCurrentMaxSessionId(branchMaxSql, high, low);
        return maxBranchId > maxTransId ? maxBranchId : maxTransId;
    }

    private long getCurrentMaxSessionId(String sql, long high, long low) {
        long max = 0L;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setLong(1, high);
            ps.setLong(2, low);
            rs = ps.executeQuery();
            while (rs.next()) {
                max = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return max;
    }

    private GlobalTransactionDO convertGlobalTransactionDO(ResultSet rs) throws SQLException {
        GlobalTransactionDO globalTransactionDO = new GlobalTransactionDO();
        globalTransactionDO.setXid(rs.getString("xid"));
        globalTransactionDO.setStatus(rs.getInt("status"));
        globalTransactionDO.setApplicationId(rs.getString("application_id"));
        globalTransactionDO.setBeginTime(rs.getLong("begin_time"));
        globalTransactionDO.setTimeout(rs.getInt("timeout"));
        globalTransactionDO.setTransactionId(rs.getLong("transaction_id"));
        globalTransactionDO.setTransactionName(rs.getString("transaction_name"));
        globalTransactionDO.setTransactionServiceGroup(rs.getString("transaction_service_group"));
        globalTransactionDO.setApplicationData(rs.getString("application_data"));
        globalTransactionDO.setGmtCreate(rs.getTimestamp("gmt_create"));
        globalTransactionDO.setGmtModified(rs.getTimestamp("gmt_modified"));
        return globalTransactionDO;
    }

    private BranchTransactionDO convertBranchTransactionDO(ResultSet rs) throws SQLException {
        BranchTransactionDO branchTransactionDO = new BranchTransactionDO();
        branchTransactionDO.setResourceGroupId(rs.getString("resource_group_id"));
        branchTransactionDO.setStatus(rs.getInt("status"));
        branchTransactionDO.setApplicationData(rs.getString("application_data"));
        branchTransactionDO.setClientId(rs.getString("client_id"));
        branchTransactionDO.setXid(rs.getString("xid"));
        branchTransactionDO.setResourceId(rs.getString("resource_id"));
        branchTransactionDO.setBranchId(rs.getLong("branch_id"));
        branchTransactionDO.setBranchType(rs.getString("branch_type"));
        branchTransactionDO.setTransactionId(rs.getLong("transaction_id"));
        branchTransactionDO.setGmtCreate(rs.getTimestamp("gmt_create"));
        branchTransactionDO.setGmtModified(rs.getTimestamp("gmt_modified"));
        return branchTransactionDO;
    }

    public void initTransactionNameSize() {
        ColumnInfo columnInfo = this.queryTableStructure(this.globalTable, TRANSACTION_NAME_KEY);
        if (columnInfo == null) {
            LOGGER.warn("{} table or {} column not found", (Object)this.globalTable, (Object)TRANSACTION_NAME_KEY);
            return;
        }
        this.transactionNameColumnSize = columnInfo.getColumnSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ColumnInfo queryTableStructure(String tableName, String colName) {
        try (Connection conn = this.logStoreDataSource.getConnection();){
            ColumnInfo info;
            String columnName;
            String table;
            DatabaseMetaData dbmd = conn.getMetaData();
            String schema = this.getSchema(conn);
            ResultSet tableRs = dbmd.getTables(null, schema, null, new String[]{"TABLE"});
            do {
                if (!tableRs.next()) return null;
            } while (!StringUtils.equalsIgnoreCase((String)(table = tableRs.getString("TABLE_NAME")), (String)tableName));
            ResultSet columnRs = conn.getMetaData().getColumns(null, schema, tableName, null);
            do {
                if (!columnRs.next()) return null;
                info = new ColumnInfo();
                columnName = columnRs.getString("COLUMN_NAME");
                info.setColumnName(columnName);
                String typeName = columnRs.getString("TYPE_NAME");
                info.setTypeName(typeName);
                int columnSize = columnRs.getInt("COLUMN_SIZE");
                info.setColumnSize(columnSize);
                String remarks = columnRs.getString("REMARKS");
                info.setRemarks(remarks);
            } while (!StringUtils.equalsIgnoreCase((String)columnName, (String)colName));
            ColumnInfo columnInfo = info;
            return columnInfo;
        }
        catch (SQLException e) {
            LOGGER.error("query transaction_name size fail, {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private String getSchema(Connection conn) throws SQLException {
        if ("h2".equalsIgnoreCase(this.dbType)) {
            return null;
        }
        return conn.getMetaData().getUserName();
    }

    public void setLogStoreDataSource(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
    }

    public void setGlobalTable(String globalTable) {
        this.globalTable = globalTable;
    }

    public void setBrachTable(String brachTable) {
        this.brachTable = brachTable;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public int getTransactionNameColumnSize() {
        return this.transactionNameColumnSize;
    }

    private static class ColumnInfo {
        private String columnName;
        private String typeName;
        private int columnSize;
        private String remarks;

        private ColumnInfo() {
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        public void setColumnSize(int columnSize) {
            this.columnSize = columnSize;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }
    }
}

