/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db;

import io.seata.common.exception.StoreException;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.constants.DBType;
import io.seata.core.store.db.DataSourceGenerator;

public abstract class AbstractDataSourceGenerator
implements DataSourceGenerator {
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final int DEFAULT_DB_MAX_CONN = 10;
    private static final int DEFAULT_DB_MIN_CONN = 1;

    protected DBType getDBType() {
        return DBType.valueof(CONFIG.getConfig("store.db.db-type"));
    }

    protected String getDriverClassName() {
        String driverClassName = CONFIG.getConfig("store.db.driver-class-name");
        if (StringUtils.isBlank((String)driverClassName)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.driver-class-name"));
        }
        return driverClassName;
    }

    protected String getUrl() {
        String url = CONFIG.getConfig("store.db.url");
        if (StringUtils.isBlank((String)url)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.url"));
        }
        return url;
    }

    protected String getUser() {
        String user = CONFIG.getConfig("store.db.user");
        if (StringUtils.isBlank((String)user)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.user"));
        }
        return user;
    }

    protected String getPassword() {
        String password = CONFIG.getConfig("store.db.password");
        return password;
    }

    protected int getMinConn() {
        int minConn = CONFIG.getInt("store.db.min-conn", 1);
        return minConn < 0 ? 1 : minConn;
    }

    protected int getMaxConn() {
        int maxConn = CONFIG.getInt("store.db.max-conn", 10);
        return maxConn < 0 ? 10 : maxConn;
    }

    protected static String getDriverName(DBType dbType) {
        if (DBType.H2.equals((Object)dbType)) {
            return "org.h2.Driver";
        }
        if (DBType.MYSQL.equals((Object)dbType)) {
            return "com.mysql.jdbc.Driver";
        }
        if (DBType.ORACLE.equals((Object)dbType)) {
            return "oracle.jdbc.OracleDriver";
        }
        if (DBType.SYBAEE.equals((Object)dbType)) {
            return "com.sybase.jdbc2.jdbc.SybDriver";
        }
        if (DBType.SQLSERVER.equals((Object)dbType)) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (DBType.SQLITE.equals((Object)dbType)) {
            return "org.sqlite.JDBC";
        }
        if (DBType.POSTGRESQL.equals((Object)dbType)) {
            return "org.postgresql.Driver";
        }
        if (DBType.ACCESS.equals((Object)dbType)) {
            return "com.hxtt.sql.access.AccessDriver";
        }
        if (DBType.DB2.equals((Object)dbType)) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        throw new StoreException("Unsupported database type, dbType:" + (Object)((Object)dbType));
    }

    protected String getValidationQuery(DBType dbType) {
        if (DBType.ORACLE.equals((Object)dbType)) {
            return "select sysdate from dual";
        }
        return "select 1";
    }
}

