/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.PlatformDependent;
import io.seata.common.exception.FrameworkException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.core.rpc.RemotingClient;
import io.seata.core.rpc.netty.AbstractRpcRemotingClient;
import io.seata.core.rpc.netty.DefaultChannelPoolHandler;
import io.seata.core.rpc.netty.NettyClientConfig;
import io.seata.core.rpc.netty.NettyPoolKey;
import io.seata.core.rpc.netty.RpcClientHandler;
import io.seata.core.rpc.netty.v1.ProtocolV1Decoder;
import io.seata.core.rpc.netty.v1.ProtocolV1Encoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientBootstrap
implements RemotingClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRpcRemotingClient.class);
    private final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private EventExecutorGroup defaultEventExecutorGroup;
    private AbstractChannelPoolMap<InetSocketAddress, FixedChannelPool> clientChannelPool;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final String THREAD_PREFIX_SPLIT_CHAR = "_";
    private final ChannelHandler channelHandler;
    private final NettyPoolKey.TransactionRole transactionRole;

    public RpcClientBootstrap(NettyClientConfig nettyClientConfig, EventExecutorGroup eventExecutorGroup, ChannelHandler channelHandler, NettyPoolKey.TransactionRole transactionRole) {
        if (null == nettyClientConfig) {
            nettyClientConfig = new NettyClientConfig();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("use default netty client config.");
            }
        }
        this.nettyClientConfig = nettyClientConfig;
        int selectorThreadSizeThreadSize = this.nettyClientConfig.getClientSelectorThreadSize();
        this.transactionRole = transactionRole;
        this.eventLoopGroupWorker = new NioEventLoopGroup(selectorThreadSizeThreadSize, (ThreadFactory)new NamedThreadFactory(this.getThreadPrefix(this.nettyClientConfig.getClientSelectorThreadPrefix()), selectorThreadSizeThreadSize));
        this.defaultEventExecutorGroup = eventExecutorGroup;
        this.channelHandler = channelHandler;
    }

    @Override
    public void start() {
        if (this.defaultEventExecutorGroup == null) {
            this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), (ThreadFactory)new NamedThreadFactory(this.getThreadPrefix(this.nettyClientConfig.getClientWorkerThreadPrefix()), this.nettyClientConfig.getClientWorkerThreads()));
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(this.nettyClientConfig.getClientChannelClazz())).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyClientConfig.getConnectTimeoutMillis())).option(ChannelOption.SO_SNDBUF, (Object)this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, (Object)this.nettyClientConfig.getClientSocketRcvBufSize());
        if (this.nettyClientConfig.enableNative()) {
            if (PlatformDependent.isOsx()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("client run on macOS");
                }
            } else {
                ((Bootstrap)this.bootstrap.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED)).option(EpollChannelOption.TCP_QUICKACK, (Object)true);
            }
        }
        if (this.nettyClientConfig.isUseConnPool()) {
            this.clientChannelPool = new AbstractChannelPoolMap<InetSocketAddress, FixedChannelPool>(){

                protected FixedChannelPool newPool(InetSocketAddress key) {
                    return new FixedChannelPool(RpcClientBootstrap.this.bootstrap.remoteAddress((SocketAddress)key), (ChannelPoolHandler)new DefaultChannelPoolHandler(){

                        @Override
                        public void channelCreated(Channel ch) throws Exception {
                            super.channelCreated(ch);
                            ChannelPipeline pipeline = ch.pipeline();
                            pipeline.addLast(RpcClientBootstrap.this.defaultEventExecutorGroup, new ChannelHandler[]{new IdleStateHandler(RpcClientBootstrap.this.nettyClientConfig.getChannelMaxReadIdleSeconds(), RpcClientBootstrap.this.nettyClientConfig.getChannelMaxWriteIdleSeconds(), RpcClientBootstrap.this.nettyClientConfig.getChannelMaxAllIdleSeconds())});
                            pipeline.addLast(RpcClientBootstrap.this.defaultEventExecutorGroup, new ChannelHandler[]{new RpcClientHandler()});
                        }
                    }, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.FAIL, RpcClientBootstrap.this.nettyClientConfig.getMaxAcquireConnMills(), RpcClientBootstrap.this.nettyClientConfig.getPerHostMaxConn(), RpcClientBootstrap.this.nettyClientConfig.getPendingConnSize(), false);
                }
            };
        } else {
            this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(RpcClientBootstrap.this.nettyClientConfig.getChannelMaxReadIdleSeconds(), RpcClientBootstrap.this.nettyClientConfig.getChannelMaxWriteIdleSeconds(), RpcClientBootstrap.this.nettyClientConfig.getChannelMaxAllIdleSeconds())}).addLast(new ChannelHandler[]{new ProtocolV1Decoder()}).addLast(new ChannelHandler[]{new ProtocolV1Encoder()});
                    if (null != RpcClientBootstrap.this.channelHandler) {
                        ch.pipeline().addLast(new ChannelHandler[]{RpcClientBootstrap.this.channelHandler});
                    }
                }
            });
        }
        if (this.initialized.compareAndSet(false, true) && LOGGER.isInfoEnabled()) {
            LOGGER.info("RpcClientBootstrap has started");
        }
    }

    @Override
    public void shutdown() {
        try {
            if (null != this.clientChannelPool) {
                this.clientChannelPool.close();
            }
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception exx) {
            LOGGER.error("Failed to shutdown: {}", (Object)exx.getMessage());
        }
    }

    public Channel getNewChannel(InetSocketAddress address) {
        Channel channel;
        ChannelFuture f = this.bootstrap.connect((SocketAddress)address);
        try {
            f.await((long)this.nettyClientConfig.getConnectTimeoutMillis(), TimeUnit.MILLISECONDS);
            if (f.isCancelled()) {
                throw new FrameworkException(f.cause(), "connect cancelled, can not connect to services-server.");
            }
            if (!f.isSuccess()) {
                throw new FrameworkException(f.cause(), "connect failed, can not connect to services-server.");
            }
            channel = f.channel();
        }
        catch (Exception e) {
            throw new FrameworkException((Throwable)e, "can not connect to services-server.");
        }
        return channel;
    }

    private String getThreadPrefix(String threadPrefix) {
        return threadPrefix + THREAD_PREFIX_SPLIT_CHAR + this.transactionRole.name();
    }
}

