/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.DurationUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ConfigurationCache
implements ConfigurationChangeListener {
    private static final String METHOD_PREFIX = "get";
    private static final String METHOD_LATEST_CONFIG = "getLatestConfig";
    private static final Map<String, ObjectWrapper> CONFIG_CACHE = new ConcurrentHashMap<String, ObjectWrapper>();
    private Map<String, HashSet<ConfigurationChangeListener>> configListenersMap = new HashMap<String, HashSet<ConfigurationChangeListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigListener(String dataId, ConfigurationChangeListener ... listeners) {
        if (StringUtils.isBlank((String)dataId)) {
            return;
        }
        Class<ConfigurationCache> clazz = ConfigurationCache.class;
        synchronized (ConfigurationCache.class) {
            HashSet listenerHashSet = ConfigurationCache.getInstance().configListenersMap.computeIfAbsent(dataId, key -> new HashSet());
            if (!listenerHashSet.contains(ConfigurationCache.getInstance())) {
                ConfigurationFactory.getInstance().addConfigListener(dataId, ConfigurationCache.getInstance());
                listenerHashSet.add(ConfigurationCache.getInstance());
            }
            if (null != listeners && listeners.length > 0) {
                for (ConfigurationChangeListener listener : listeners) {
                    if (listenerHashSet.contains(listener)) continue;
                    listenerHashSet.add(listener);
                    ConfigurationFactory.getInstance().addConfigListener(dataId, listener);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfigListener(String dataId, ConfigurationChangeListener ... listeners) {
        if (StringUtils.isBlank((String)dataId)) {
            return;
        }
        Class<ConfigurationCache> clazz = ConfigurationCache.class;
        synchronized (ConfigurationCache.class) {
            HashSet<ConfigurationChangeListener> listenerSet = ConfigurationCache.getInstance().configListenersMap.get(dataId);
            if (CollectionUtils.isNotEmpty(listenerSet)) {
                for (ConfigurationChangeListener listener : listeners) {
                    if (!listenerSet.remove(listener)) continue;
                    ConfigurationFactory.getInstance().removeConfigListener(dataId, listener);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ConfigurationCache getInstance() {
        return ConfigurationCacheInstance.INSTANCE;
    }

    @Override
    public void onChangeEvent(ConfigurationChangeEvent event) {
        ObjectWrapper oldWrapper = CONFIG_CACHE.get(event.getDataId());
        if (StringUtils.isNotBlank((String)event.getNewValue())) {
            if (oldWrapper == null) {
                CONFIG_CACHE.put(event.getDataId(), new ObjectWrapper(event.getNewValue(), null));
            } else {
                Object newValue = new ObjectWrapper(event.getNewValue(), null).convertData(oldWrapper.getType());
                if (!Objects.equals(oldWrapper.getData(), newValue)) {
                    CONFIG_CACHE.put(event.getDataId(), new ObjectWrapper(newValue, oldWrapper.getType(), oldWrapper.getLastDefaultValue()));
                }
            }
        } else {
            CONFIG_CACHE.remove(event.getDataId());
        }
    }

    public Configuration proxy(Configuration originalConfiguration) throws Exception {
        return (Configuration)new ByteBuddy().subclass(Configuration.class).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((proxy, method, args) -> {
            String methodName = method.getName();
            if (methodName.startsWith(METHOD_PREFIX) && !method.getName().equalsIgnoreCase(METHOD_LATEST_CONFIG)) {
                Object result;
                String rawDataId = (String)args[0];
                ObjectWrapper wrapper = CONFIG_CACHE.get(rawDataId);
                ObjectWrapper.ConfigType type = ObjectWrapper.getTypeByName(method.getName().substring(METHOD_PREFIX.length()));
                Object defaultValue = null;
                if (args.length > 1 && method.getParameterTypes()[1].getSimpleName().equalsIgnoreCase(type.name())) {
                    defaultValue = args[1];
                }
                if ((null == wrapper || null != defaultValue && !Objects.equals(defaultValue, wrapper.lastDefaultValue)) && (result = method.invoke((Object)originalConfiguration, args)) != null) {
                    wrapper = new ObjectWrapper(result, type, defaultValue);
                    CONFIG_CACHE.put(rawDataId, wrapper);
                }
                return wrapper == null ? null : wrapper.convertData(type);
            }
            return method.invoke((Object)originalConfiguration, args);
        })).make().load(originalConfiguration.getClass().getClassLoader()).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static void clear() {
        CONFIG_CACHE.clear();
    }

    private static class ObjectWrapper {
        private final Object data;
        private final ConfigType type;
        private final Object lastDefaultValue;

        ObjectWrapper(Object data, ConfigType type) {
            this(data, type, null);
        }

        ObjectWrapper(Object data, ConfigType type, Object lastDefaultValue) {
            this.data = data;
            this.type = type;
            this.lastDefaultValue = lastDefaultValue;
        }

        public Object getData() {
            return this.data;
        }

        public ConfigType getType() {
            return this.type;
        }

        public Object getLastDefaultValue() {
            return this.lastDefaultValue;
        }

        public Object convertData(ConfigType aType) {
            if (this.data != null && Objects.equals((Object)this.type, (Object)aType)) {
                return this.data;
            }
            if (this.data != null) {
                if (ConfigType.INT.equals((Object)aType)) {
                    return Integer.parseInt(this.data.toString());
                }
                if (ConfigType.BOOLEAN.equals((Object)aType)) {
                    return Boolean.parseBoolean(this.data.toString());
                }
                if (ConfigType.DURATION.equals((Object)aType)) {
                    return DurationUtil.parse((String)this.data.toString());
                }
                if (ConfigType.LONG.equals((Object)aType)) {
                    return Long.parseLong(this.data.toString());
                }
                if (ConfigType.SHORT.equals((Object)aType)) {
                    return Short.parseShort(this.data.toString());
                }
                return String.valueOf(this.data);
            }
            return null;
        }

        public static boolean supportType(String type) {
            return ObjectWrapper.getTypeByName(type) != null;
        }

        public static ConfigType getTypeByName(String postfix) {
            return ConfigType.fromCode(postfix);
        }

        static enum ConfigType {
            INT("Int"),
            BOOLEAN("Boolean"),
            DURATION("Duration"),
            LONG("Long"),
            SHORT("Short"),
            STRING("Config");

            private static final Map<String, ConfigType> CODE_TO_VALUE;
            private String code;

            private ConfigType(String code) {
                this.code = code;
            }

            public String getCode() {
                return this.code;
            }

            public static ConfigType fromCode(String code) {
                ConfigType configType = CODE_TO_VALUE.get(code.toUpperCase());
                return configType == null ? STRING : configType;
            }

            public static ConfigType fromName(String name) {
                return ConfigType.valueOf(name);
            }

            static {
                CODE_TO_VALUE = new HashMap<String, ConfigType>();
                for (ConfigType configType : ConfigType.values()) {
                    CODE_TO_VALUE.put(configType.code.toUpperCase(), configType);
                }
            }
        }
    }

    private static class ConfigurationCacheInstance {
        private static final ConfigurationCache INSTANCE = new ConfigurationCache();

        private ConfigurationCacheInstance() {
        }
    }
}

